/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.ant;

import java.io.PrintStream;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.diff.Diff;
import liquibase.diff.DiffResult;
import liquibase.integration.ant.BaseLiquibaseTask;
import liquibase.util.StringUtils;
import org.apache.tools.ant.BuildException;

public class DiffDatabaseTask
extends BaseLiquibaseTask {
    private String referenceDriver;
    private String referenceUrl;
    private String referenceUsername;
    private String referencePassword;
    private String referenceDefaultSchemaName;
    private String diffTypes;
    private String dataDir;

    public String getDiffTypes() {
        return this.diffTypes;
    }

    public void setDiffTypes(String diffTypes) {
        this.diffTypes = diffTypes;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public void setDataDir(String dataDir) {
        this.dataDir = dataDir;
    }

    public String getReferenceDriver() {
        return this.referenceDriver;
    }

    public void setReferenceDriver(String referenceDriver) {
        this.referenceDriver = referenceDriver;
    }

    public String getReferenceUrl() {
        return this.referenceUrl;
    }

    public void setReferenceUrl(String referenceUrl) {
        this.referenceUrl = referenceUrl;
    }

    public String getReferenceUsername() {
        return this.referenceUsername;
    }

    public void setReferenceUsername(String referenceUsername) {
        this.referenceUsername = referenceUsername;
    }

    public String getReferencePassword() {
        return this.referencePassword;
    }

    public void setReferencePassword(String referencePassword) {
        this.referencePassword = referencePassword;
    }

    public String getReferenceDefaultSchemaName() {
        return this.referenceDefaultSchemaName;
    }

    public void setReferenceDefaultSchemaName(String referenceDefaultSchemaName) {
        this.referenceDefaultSchemaName = referenceDefaultSchemaName;
    }

    public void execute() throws BuildException {
        if (StringUtils.trimToNull(this.getReferenceUrl()) == null) {
            throw new BuildException("diffDatabase requires referenceUrl to be set");
        }
        Liquibase liquibase = null;
        try {
            PrintStream writer = this.createPrintStream();
            if (writer == null && this.getChangeLogFile() == null) {
                throw new BuildException("diffDatabase requires outputFile or changeLogFile to be set");
            }
            liquibase = this.createLiquibase();
            Database referenceDatabase = this.createDatabaseObject(this.getReferenceDriver(), this.getReferenceUrl(), this.getReferenceUsername(), this.getReferencePassword(), this.getReferenceDefaultSchemaName(), this.getDatabaseClass());
            Diff diff = new Diff(referenceDatabase, liquibase.getDatabase());
            if (this.getDiffTypes() != null) {
                diff.setDiffTypes(this.getDiffTypes());
            }
            DiffResult diffResult = diff.compare();
            if (this.getDataDir() != null) {
                diffResult.setDataDir(this.getDataDir());
            }
            this.outputDiff(writer, diffResult, liquibase.getDatabase());
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
        catch (Exception e) {
            try {
                throw new BuildException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.closeDatabase(liquibase);
                throw throwable;
            }
        }
        this.closeDatabase(liquibase);
    }

    protected void outputDiff(PrintStream writer, DiffResult diffResult, Database targetDatabase) throws Exception {
        diffResult.printResult(writer);
    }
}

