/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.core.formattedsql;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.change.AbstractSQLChange;
import liquibase.change.core.RawSQLChange;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.exception.ChangeLogParseException;
import liquibase.logging.LogFactory;
import liquibase.parser.ChangeLogParser;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StringUtils;

public class FormattedSqlChangeLogParser
implements ChangeLogParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supports(String changeLogFile, ResourceAccessor resourceAccessor) {
        BufferedReader reader = null;
        try {
            if (changeLogFile.endsWith(".sql")) {
                reader = new BufferedReader(new InputStreamReader(this.openChangeLogFile(changeLogFile, resourceAccessor)));
                boolean bl = reader.readLine().startsWith("--liquibase formatted");
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LogFactory.getLogger().debug("Exception reading " + changeLogFile, e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LogFactory.getLogger().debug("Exception closing " + changeLogFile, e);
                }
            }
        }
    }

    public int getPriority() {
        return 6;
    }

    public DatabaseChangeLog parse(String physicalChangeLogLocation, ChangeLogParameters changeLogParameters, ResourceAccessor resourceAccessor) throws ChangeLogParseException {
        DatabaseChangeLog changeLog = new DatabaseChangeLog(physicalChangeLogLocation);
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(this.openChangeLogFile(physicalChangeLogLocation, resourceAccessor)));
            StringBuffer currentSql = new StringBuffer();
            ChangeSet changeSet = null;
            AbstractSQLChange change = null;
            Pattern changeSetPattern = Pattern.compile("--changeset (\\w+):(\\w+).*", 2);
            Pattern stripCommentsPattern = Pattern.compile(".*stripComments:(\\w+).*", 2);
            Pattern splitStatementsPattern = Pattern.compile(".*splitStatements:(\\w+).*", 2);
            Pattern endDelimiterPattern = Pattern.compile(".*endDelimiter:(\\w+).*", 2);
            Pattern runOnChangePattern = Pattern.compile(".*runOnChange:(\\w+).*", 2);
            Pattern runAlwaysPattern = Pattern.compile(".*runAlways:(\\w+).*", 2);
            Pattern contextPattern = Pattern.compile(".*context:(\\w+).*", 2);
            Pattern runInTransactionPattern = Pattern.compile(".*runInTransaction:(\\w+).*", 2);
            Pattern dbmsPattern = Pattern.compile(".*dbms:(\\w+).*", 2);
            Pattern failOnErrorPattern = Pattern.compile(".*failOnError:(\\w+).*", 2);
            while ((line = reader.readLine()) != null) {
                Matcher changeSetPatternMatcher = changeSetPattern.matcher(line);
                if (changeSetPatternMatcher.matches()) {
                    String finalCurrentSql = StringUtils.trimToNull(currentSql.toString());
                    if (changeSet != null) {
                        if (finalCurrentSql == null) {
                            throw new ChangeLogParseException("No SQL for changeset " + changeSet.toString(false));
                        }
                        change.setSql(finalCurrentSql);
                    }
                    Matcher stripCommentsPatternMatcher = stripCommentsPattern.matcher(line);
                    Matcher splitStatementsPatternMatcher = splitStatementsPattern.matcher(line);
                    Matcher endDelimiterPatternMatcher = endDelimiterPattern.matcher(line);
                    Matcher runOnChangePatternMatcher = runOnChangePattern.matcher(line);
                    Matcher runAlwaysPatternMatcher = runAlwaysPattern.matcher(line);
                    Matcher contextPatternMatcher = contextPattern.matcher(line);
                    Matcher runInTransactionPatternMatcher = runInTransactionPattern.matcher(line);
                    Matcher dbmsPatternMatcher = dbmsPattern.matcher(line);
                    Matcher failOnErrorPatternMatcher = failOnErrorPattern.matcher(line);
                    boolean stripComments = this.parseBoolean(stripCommentsPatternMatcher, changeSet, true);
                    boolean splitStatements = this.parseBoolean(splitStatementsPatternMatcher, changeSet, true);
                    boolean runOnChange = this.parseBoolean(runOnChangePatternMatcher, changeSet, false);
                    boolean runAlways = this.parseBoolean(runAlwaysPatternMatcher, changeSet, false);
                    boolean runInTransaction = this.parseBoolean(runInTransactionPatternMatcher, changeSet, true);
                    boolean failOnError = this.parseBoolean(failOnErrorPatternMatcher, changeSet, true);
                    String endDelimiter = this.parseString(endDelimiterPatternMatcher);
                    String context = this.parseString(contextPatternMatcher);
                    String dbms = this.parseString(dbmsPatternMatcher);
                    changeSet = new ChangeSet(changeSetPatternMatcher.group(2), changeSetPatternMatcher.group(1), runAlways, runOnChange, physicalChangeLogLocation, physicalChangeLogLocation, context, dbms, runInTransaction);
                    changeSet.setFailOnError(failOnError);
                    changeLog.addChangeSet(changeSet);
                    change = new RawSQLChange();
                    change.setSql(finalCurrentSql);
                    change.setResourceAccessor(resourceAccessor);
                    change.setSplitStatements(splitStatements);
                    change.setStripComments(stripComments);
                    change.setEndDelimiter(endDelimiter);
                    changeSet.addChange(change);
                    currentSql = new StringBuffer();
                    continue;
                }
                if (changeSet == null) continue;
                currentSql.append(line).append("\n");
            }
            if (changeSet != null) {
                change.setSql(StringUtils.trimToNull(currentSql.toString()));
            }
        }
        catch (IOException e) {
            throw new ChangeLogParseException(e);
        }
        return changeLog;
    }

    private String parseString(Matcher matcher) {
        String endDelimiter = null;
        if (matcher.matches()) {
            endDelimiter = matcher.group(1);
        }
        return endDelimiter;
    }

    private boolean parseBoolean(Matcher matcher, ChangeSet changeSet, boolean defaultValue) throws ChangeLogParseException {
        boolean stripComments = defaultValue;
        if (matcher.matches()) {
            try {
                stripComments = Boolean.parseBoolean(matcher.group(1));
            }
            catch (Exception e) {
                throw new ChangeLogParseException("Cannot parse " + changeSet + " " + matcher.toString().replaceAll("\\.*", "") + " as a boolean");
            }
        }
        return stripComments;
    }

    protected InputStream openChangeLogFile(String physicalChangeLogLocation, ResourceAccessor resourceAccessor) throws IOException {
        return resourceAccessor.getResourceAsStream(physicalChangeLogLocation);
    }
}

