/*
 * Decompiled with CFR 0.152.
 */
package liquibase.snapshot;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import liquibase.database.Database;
import liquibase.database.structure.Column;
import liquibase.database.structure.ForeignKey;
import liquibase.database.structure.Index;
import liquibase.database.structure.PrimaryKey;
import liquibase.database.structure.Sequence;
import liquibase.database.structure.Table;
import liquibase.database.structure.UniqueConstraint;
import liquibase.database.structure.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseSnapshot {
    private Database database;
    private Set<Table> tables = new HashSet<Table>();
    private Set<View> views = new HashSet<View>();
    private Set<ForeignKey> foreignKeys = new HashSet<ForeignKey>();
    private Set<UniqueConstraint> uniqueConstraints = new HashSet<UniqueConstraint>();
    private Set<Index> indexes = new HashSet<Index>();
    private Set<PrimaryKey> primaryKeys = new HashSet<PrimaryKey>();
    private Set<Sequence> sequences = new HashSet<Sequence>();
    private String schema;
    private Table databaseChangeLogTable;
    private Table databaseChangeLogLockTable;

    public DatabaseSnapshot(Database database, String requestedSchema) {
        this.database = database;
        this.schema = requestedSchema;
    }

    public Database getDatabase() {
        return this.database;
    }

    public Set<Table> getTables() {
        return this.tables;
    }

    public Set<View> getViews() {
        return this.views;
    }

    public Set<ForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    public Set<Index> getIndexes() {
        return this.indexes;
    }

    public Set<PrimaryKey> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public Set<Sequence> getSequences() {
        return this.sequences;
    }

    public Set<UniqueConstraint> getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    public Table getTable(String tableName) {
        for (Table table : this.getTables()) {
            if (!table.getName().equalsIgnoreCase(tableName)) continue;
            return table;
        }
        return null;
    }

    public ForeignKey getForeignKey(String foreignKeyName) {
        for (ForeignKey fk : this.getForeignKeys()) {
            if (!fk.getName().equalsIgnoreCase(foreignKeyName)) continue;
            return fk;
        }
        return null;
    }

    public Sequence getSequence(String sequenceName) {
        for (Sequence sequence : this.getSequences()) {
            if (!sequence.getName().equalsIgnoreCase(sequenceName)) continue;
            return sequence;
        }
        return null;
    }

    public Index getIndex(String indexName) {
        for (Index index : this.getIndexes()) {
            if (!index.getName().equalsIgnoreCase(indexName)) continue;
            return index;
        }
        return null;
    }

    public View getView(String viewName) {
        for (View view : this.getViews()) {
            if (!view.getName().equalsIgnoreCase(viewName)) continue;
            return view;
        }
        return null;
    }

    public PrimaryKey getPrimaryKey(String pkName) {
        for (PrimaryKey pk : this.getPrimaryKeys()) {
            if (!pk.getName().equalsIgnoreCase(pkName)) continue;
            return pk;
        }
        return null;
    }

    public PrimaryKey getPrimaryKeyForTable(String tableName) {
        for (PrimaryKey pk : this.getPrimaryKeys()) {
            if (!pk.getTable().getName().equalsIgnoreCase(tableName)) continue;
            return pk;
        }
        return null;
    }

    public UniqueConstraint getUniqueConstraint(String ucName) {
        for (UniqueConstraint uc : this.getUniqueConstraints()) {
            if (!uc.getName().equalsIgnoreCase(ucName)) continue;
            return uc;
        }
        return null;
    }

    public String getSchema() {
        return this.schema;
    }

    public boolean isPrimaryKey(Column columnInfo) {
        for (PrimaryKey pk : this.getPrimaryKeys()) {
            if (columnInfo.getTable() == null || !pk.getTable().getName().equalsIgnoreCase(columnInfo.getTable().getName()) || !pk.getColumnNamesAsList().contains(columnInfo.getName())) continue;
            return true;
        }
        return false;
    }

    public Collection<Column> getColumns() {
        HashSet<Column> returnSet = new HashSet<Column>();
        for (Table table : this.getTables()) {
            for (Column column : table.getColumns()) {
                returnSet.add(column);
            }
        }
        return returnSet;
    }

    public Column getColumn(String tableName, String columnName) {
        for (Table table : this.getTables()) {
            for (Column column : table.getColumns()) {
                if (!table.getName().equalsIgnoreCase(tableName) || !column.getName().equalsIgnoreCase(columnName)) continue;
                return column;
            }
        }
        return null;
    }

    public boolean hasDatabaseChangeLogTable() {
        return this.databaseChangeLogTable != null;
    }

    public Table getDatabaseChangeLogTable() {
        return this.databaseChangeLogTable;
    }

    public void setDatabaseChangeLogTable(Table table) {
        this.databaseChangeLogTable = table;
    }

    public Table getDatabaseChangeLogLockTable() {
        return this.databaseChangeLogLockTable;
    }

    public void setDatabaseChangeLogLockTable(Table table) {
        this.databaseChangeLogLockTable = table;
    }
}

