/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import liquibase.database.Database;
import liquibase.database.core.SybaseDatabase;
import liquibase.database.structure.type.DataType;
import liquibase.database.typeconversion.TypeConverter;
import liquibase.database.typeconversion.TypeConverterFactory;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.NotNullConstraint;
import liquibase.statement.UniqueConstraint;
import liquibase.statement.core.CreateDatabaseChangeLogTableStatement;
import liquibase.statement.core.CreateTableStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateDatabaseChangeLogTableGenerator
extends AbstractSqlGenerator<CreateDatabaseChangeLogTableStatement> {
    @Override
    public boolean supports(CreateDatabaseChangeLogTableStatement statement, Database database) {
        return !(database instanceof SybaseDatabase);
    }

    @Override
    public ValidationErrors validate(CreateDatabaseChangeLogTableStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        return new ValidationErrors();
    }

    @Override
    public Sql[] generateSql(CreateDatabaseChangeLogTableStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        TypeConverter typeConverter = TypeConverterFactory.getInstance().findTypeConverter(database);
        CreateTableStatement createTableStatement = new CreateTableStatement(database.getLiquibaseSchemaName(), database.getDatabaseChangeLogTableName()).addPrimaryKeyColumn("ID", typeConverter.getDataType("VARCHAR(63)", false), null, null, null, new NotNullConstraint()).addPrimaryKeyColumn("AUTHOR", typeConverter.getDataType("VARCHAR(63)", false), null, null, null, new NotNullConstraint()).addPrimaryKeyColumn("FILENAME", typeConverter.getDataType("VARCHAR(200)", false), null, null, null, new NotNullConstraint()).addColumn("DATEEXECUTED", (DataType)typeConverter.getDateTimeType(), null, new NotNullConstraint()).addColumn("ORDEREXECUTED", typeConverter.getDataType("INT", false), new NotNullConstraint(), new UniqueConstraint("UQ_DBCL_ORDEREXEC")).addColumn("EXECTYPE", typeConverter.getDataType("VARCHAR(10)", false), (Object)new NotNullConstraint()).addColumn("MD5SUM", typeConverter.getDataType("VARCHAR(35)", false)).addColumn("DESCRIPTION", typeConverter.getDataType("VARCHAR(255)", false)).addColumn("COMMENTS", typeConverter.getDataType("VARCHAR(255)", false)).addColumn("TAG", typeConverter.getDataType("VARCHAR(255)", false)).addColumn("LIQUIBASE", typeConverter.getDataType("VARCHAR(20)", false));
        return SqlGeneratorFactory.getInstance().generateSql(createTableStatement, database);
    }
}

