/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import liquibase.change.Change;
import liquibase.change.ChangeMetaData;
import liquibase.change.ChangeProperty;
import liquibase.change.CheckSum;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.database.structure.DatabaseObject;
import liquibase.exception.RollbackImpossibleException;
import liquibase.exception.SetupException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.resource.ResourceAccessor;
import liquibase.serializer.core.string.StringChangeLogSerializer;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.SqlStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractChange
implements Change {
    @ChangeProperty(includeInSerialization=false)
    private ChangeMetaData changeMetaData;
    @ChangeProperty(includeInSerialization=false)
    private ResourceAccessor resourceAccessor;
    @ChangeProperty(includeInSerialization=false)
    private ChangeSet changeSet;

    protected AbstractChange(String changeName, String changeDescription, int priority) {
        this.changeMetaData = new ChangeMetaData(changeName, changeDescription, priority);
    }

    @Override
    public ChangeMetaData getChangeMetaData() {
        return this.changeMetaData;
    }

    protected void setPriority(int newPriority) {
        this.changeMetaData.setPriority(newPriority);
    }

    @Override
    public ChangeSet getChangeSet() {
        return this.changeSet;
    }

    @Override
    public void setChangeSet(ChangeSet changeSet) {
        this.changeSet = changeSet;
    }

    @Override
    public boolean requiresUpdatedDatabaseMetadata(Database database) {
        for (SqlStatement statement : this.generateStatements(database)) {
            if (!SqlGeneratorFactory.getInstance().requiresCurrentDatabaseMetadata(statement, database)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supports(Database database) {
        for (SqlStatement statement : this.generateStatements(database)) {
            if (SqlGeneratorFactory.getInstance().supports(statement, database)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Warnings warn(Database database) {
        Warnings warnings = new Warnings();
        for (SqlStatement statement : this.generateStatements(database)) {
            if (!SqlGeneratorFactory.getInstance().supports(statement, database)) continue;
            warnings.addAll(SqlGeneratorFactory.getInstance().warn(statement, database));
        }
        return warnings;
    }

    @Override
    public ValidationErrors validate(Database database) {
        ValidationErrors changeValidationErrors = new ValidationErrors();
        for (SqlStatement statement : this.generateStatements(database)) {
            if (!SqlGeneratorFactory.getInstance().supports(statement, database)) {
                changeValidationErrors.addError(this.getChangeMetaData().getName() + " is not supported on " + database.getTypeName());
                continue;
            }
            changeValidationErrors.addAll(SqlGeneratorFactory.getInstance().validate(statement, database));
        }
        return changeValidationErrors;
    }

    @Override
    public SqlStatement[] generateRollbackStatements(Database database) throws UnsupportedChangeException, RollbackImpossibleException {
        return this.generateRollbackStatementsFromInverse(database);
    }

    @Override
    public boolean supportsRollback(Database database) {
        return this.createInverses() != null;
    }

    @Override
    public CheckSum generateCheckSum() {
        return CheckSum.compute(new StringChangeLogSerializer().serialize(this));
    }

    private SqlStatement[] generateRollbackStatementsFromInverse(Database database) throws UnsupportedChangeException, RollbackImpossibleException {
        Change[] inverses = this.createInverses();
        if (inverses == null) {
            throw new RollbackImpossibleException("No inverse to " + this.getClass().getName() + " created");
        }
        ArrayList<SqlStatement> statements = new ArrayList<SqlStatement>();
        for (Change inverse : inverses) {
            statements.addAll(Arrays.asList(inverse.generateStatements(database)));
        }
        return statements.toArray(new SqlStatement[statements.size()]);
    }

    protected Change[] createInverses() {
        return null;
    }

    @Override
    public void setResourceAccessor(ResourceAccessor resourceAccessor) {
        this.resourceAccessor = resourceAccessor;
    }

    public ResourceAccessor getResourceAccessor() {
        return this.resourceAccessor;
    }

    @Override
    public void init() throws SetupException {
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects(Database database) {
        HashSet<DatabaseObject> affectedObjects = new HashSet<DatabaseObject>();
        for (SqlStatement statement : this.generateStatements(database)) {
            affectedObjects.addAll(SqlGeneratorFactory.getInstance().getAffectedDatabaseObjects(statement, database));
        }
        return affectedObjects;
    }
}

