/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.ArrayList;
import liquibase.change.AbstractChange;
import liquibase.database.Database;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.util.StringUtils;

public abstract class AbstractSQLChange
extends AbstractChange {
    private boolean stripComments = false;
    private boolean splitStatements = true;
    private String endDelimiter;
    private String sql;

    protected AbstractSQLChange(String tagName, String changeName, int priority) {
        super(tagName, changeName, priority);
    }

    public boolean supports(Database database) {
        return true;
    }

    public void setStripComments(Boolean stripComments) {
        this.stripComments = stripComments;
    }

    public boolean isStrippingComments() {
        return this.stripComments;
    }

    public void setSplitStatements(Boolean splitStatements) {
        this.splitStatements = splitStatements;
    }

    public boolean isSplittingStatements() {
        return this.splitStatements;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = StringUtils.trimToNull(sql);
    }

    public String getEndDelimiter() {
        return this.endDelimiter;
    }

    public void setEndDelimiter(String endDelimiter) {
        this.endDelimiter = endDelimiter;
    }

    public SqlStatement[] generateStatements(Database database) {
        ArrayList<RawSqlStatement> returnStatements = new ArrayList<RawSqlStatement>();
        if (StringUtils.trimToNull(this.getSql()) == null) {
            return new SqlStatement[0];
        }
        String processedSQL = this.getSql().replaceAll("\r\n", "\n").replaceAll("\r", "\n");
        for (String statement : StringUtils.processMutliLineSQL(processedSQL, this.isStrippingComments(), this.isSplittingStatements(), this.getEndDelimiter())) {
            returnStatements.add(new RawSqlStatement(statement, this.getEndDelimiter()));
        }
        return returnStatements.toArray(new SqlStatement[returnStatements.size()]);
    }
}

