/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import liquibase.change.AbstractChange;
import liquibase.change.ChangeWithColumns;
import liquibase.change.CheckSum;
import liquibase.change.ColumnConfig;
import liquibase.change.core.LoadDataColumnConfig;
import liquibase.database.Database;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.InsertStatement;
import liquibase.util.StringUtils;
import liquibase.util.csv.CSVReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadDataChange
extends AbstractChange
implements ChangeWithColumns {
    private String schemaName;
    private String tableName;
    private String file;
    private String encoding = null;
    private List<LoadDataColumnConfig> columns = new ArrayList<LoadDataColumnConfig>();

    public LoadDataChange() {
        super("loadData", "Load Data", 1);
    }

    protected LoadDataChange(String changeName, String changeDescription) {
        super(changeName, changeDescription, 1);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = StringUtils.trimToNull(schemaName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public void addColumn(ColumnConfig column) {
        this.columns.add((LoadDataColumnConfig)column);
    }

    @Override
    public List<ColumnConfig> getColumns() {
        return this.columns;
    }

    @Override
    public SqlStatement[] generateStatements(Database database) {
        try {
            CSVReader reader = this.getCSVReader();
            String[] headers = reader.readNext();
            if (headers == null) {
                throw new UnexpectedLiquibaseException("Data file " + this.getFile() + " was empty");
            }
            ArrayList<InsertStatement> statements = new ArrayList<InsertStatement>();
            String[] line = null;
            while ((line = reader.readNext()) != null) {
                if (line.length == 0 || line.length == 1 && StringUtils.trimToNull(line[0]) == null) continue;
                InsertStatement insertStatement = this.createStatement(this.getSchemaName(), this.getTableName());
                for (int i = 0; i < headers.length; ++i) {
                    String columnName = null;
                    Object value = line[i];
                    ColumnConfig columnConfig = this.getColumnConfig(i, headers[i]);
                    if (columnConfig != null) {
                        columnName = columnConfig.getName();
                        if (value.toString().equalsIgnoreCase("NULL")) {
                            value = "NULL";
                        } else if (columnConfig.getType() != null) {
                            ColumnConfig valueConfig = new ColumnConfig();
                            if (columnConfig.getType().equalsIgnoreCase("BOOLEAN")) {
                                valueConfig.setValueBoolean(Boolean.parseBoolean(value.toString().toLowerCase()));
                            } else if (columnConfig.getType().equalsIgnoreCase("NUMERIC")) {
                                valueConfig.setValueNumeric(value.toString());
                            } else if (columnConfig.getType().toLowerCase().contains("date") || columnConfig.getType().toLowerCase().contains("time")) {
                                valueConfig.setValueDate(value.toString());
                            } else if (columnConfig.getType().equalsIgnoreCase("STRING")) {
                                valueConfig.setValue(value.toString());
                            } else if (columnConfig.getType().equalsIgnoreCase("COMPUTED")) {
                                valueConfig.setValue(value.toString());
                            } else {
                                throw new UnexpectedLiquibaseException("loadData type of " + columnConfig.getType() + " is not supported.  Please use BOOLEAN, NUMERIC, DATE, STRING, or COMPUTED");
                            }
                            value = valueConfig.getValueObject();
                        }
                    }
                    if (columnName == null) {
                        columnName = headers[i];
                    }
                    insertStatement.addColumnValue(columnName, value);
                }
                statements.add(insertStatement);
            }
            return statements.toArray(new SqlStatement[statements.size()]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected CSVReader getCSVReader() throws IOException {
        ResourceAccessor opener = this.getResourceAccessor();
        if (opener == null) {
            throw new UnexpectedLiquibaseException("No file opener specified for " + this.getFile());
        }
        InputStream stream = opener.getResourceAsStream(this.getFile());
        if (stream == null) {
            throw new UnexpectedLiquibaseException("Data file " + this.getFile() + " was not found");
        }
        InputStreamReader streamReader = this.getEncoding() == null ? new InputStreamReader(stream) : new InputStreamReader(stream, this.getEncoding());
        CSVReader reader = new CSVReader(streamReader);
        return reader;
    }

    protected InsertStatement createStatement(String schemaName, String tableName) {
        return new InsertStatement(schemaName, tableName);
    }

    protected ColumnConfig getColumnConfig(int index, String header) {
        for (LoadDataColumnConfig config : this.columns) {
            if (config.getIndex() != null && config.getIndex().equals(index)) {
                return config;
            }
            if (config.getHeader() != null && config.getHeader().equalsIgnoreCase(header)) {
                return config;
            }
            if (config.getName() == null || !config.getName().equalsIgnoreCase(header)) continue;
            return config;
        }
        return null;
    }

    @Override
    public String getConfirmationMessage() {
        return "Data loaded from " + this.getFile() + " into " + this.getTableName();
    }

    @Override
    public CheckSum generateCheckSum() {
        InputStream stream = null;
        try {
            stream = this.getResourceAccessor().getResourceAsStream(this.getFile());
            if (stream == null) {
                throw new RuntimeException(this.getFile() + " could not be found");
            }
            CheckSum checkSum = CheckSum.compute(stream);
            return checkSum;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

