/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.util.ArrayList;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RenameTableStatement;
import liquibase.statement.core.ReorganizeTableStatement;
import liquibase.util.StringUtils;

public class RenameTableChange
extends AbstractChange {
    private String schemaName;
    private String oldTableName;
    private String newTableName;

    public RenameTableChange() {
        super("renameTable", "Rename Table", 1);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = StringUtils.trimToNull(schemaName);
    }

    public String getOldTableName() {
        return this.oldTableName;
    }

    public void setOldTableName(String oldTableName) {
        this.oldTableName = oldTableName;
    }

    public String getNewTableName() {
        return this.newTableName;
    }

    public void setNewTableName(String newTableName) {
        this.newTableName = newTableName;
    }

    public SqlStatement[] generateStatements(Database database) {
        ArrayList<SqlStatement> statements = new ArrayList<SqlStatement>();
        String schemaName = this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName();
        statements.add(new RenameTableStatement(schemaName, this.getOldTableName(), this.getNewTableName()));
        if (database instanceof DB2Database) {
            statements.add(new ReorganizeTableStatement(schemaName, this.getNewTableName()));
        }
        return statements.toArray(new SqlStatement[statements.size()]);
    }

    protected Change[] createInverses() {
        RenameTableChange inverse = new RenameTableChange();
        inverse.setSchemaName(this.getSchemaName());
        inverse.setOldTableName(this.getNewTableName());
        inverse.setNewTableName(this.getOldTableName());
        return new Change[]{inverse};
    }

    public String getConfirmationMessage() {
        return "Table " + this.oldTableName + " renamed to " + this.newTableName;
    }
}

