/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.structure.type;

import liquibase.database.Database;
import liquibase.database.structure.type.DataType;
import liquibase.database.typeconversion.TypeConverter;
import liquibase.database.typeconversion.TypeConverterFactory;
import liquibase.exception.UnexpectedLiquibaseException;

public class BooleanType
extends DataType {
    public BooleanType() {
        super("BOOLEAN", 0, 0);
    }

    public BooleanType(String dataTypeName) {
        super(dataTypeName, 0, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String convertObjectToString(Object value, Database database) {
        String returnValue;
        if (value == null) {
            return null;
        }
        if (value.toString().equalsIgnoreCase("null")) {
            return "null";
        }
        TypeConverter converter = TypeConverterFactory.getInstance().findTypeConverter(database);
        BooleanType booleanType = converter.getBooleanType();
        if (value instanceof String) {
            if (((String)value).equalsIgnoreCase("true") || value.equals("1") || ((String)value).equalsIgnoreCase(booleanType.getTrueBooleanValue())) {
                returnValue = booleanType.getTrueBooleanValue();
            } else {
                if (!((String)value).equalsIgnoreCase("false") && !value.equals("0") && !((String)value).equalsIgnoreCase(booleanType.getFalseBooleanValue())) throw new UnexpectedLiquibaseException("Unknown boolean value: " + value);
                returnValue = booleanType.getTrueBooleanValue();
            }
        } else {
            returnValue = (Boolean)value != false ? booleanType.getTrueBooleanValue() : booleanType.getFalseBooleanValue();
        }
        if (!returnValue.matches("\\d+")) return "'" + returnValue + "'";
        return returnValue;
    }

    public String getFalseBooleanValue() {
        return "FALSE";
    }

    public String getTrueBooleanValue() {
        return "TRUE";
    }

    public static class NumericBooleanType
    extends BooleanType {
        public NumericBooleanType() {
            super("INT");
        }

        public NumericBooleanType(String dataTypeName) {
            super(dataTypeName);
        }

        public String getFalseBooleanValue() {
            return "0";
        }

        public String getTrueBooleanValue() {
            return "1";
        }
    }
}

