/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.typeconversion.core;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import liquibase.change.ColumnConfig;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.core.H2Database;
import liquibase.database.core.HsqlDatabase;
import liquibase.database.core.InformixDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.database.structure.Column;
import liquibase.database.structure.type.BigIntType;
import liquibase.database.structure.type.BlobType;
import liquibase.database.structure.type.BooleanType;
import liquibase.database.structure.type.CharType;
import liquibase.database.structure.type.ClobType;
import liquibase.database.structure.type.CurrencyType;
import liquibase.database.structure.type.CustomType;
import liquibase.database.structure.type.DataType;
import liquibase.database.structure.type.DatabaseFunctionType;
import liquibase.database.structure.type.DateTimeType;
import liquibase.database.structure.type.DateType;
import liquibase.database.structure.type.DoubleType;
import liquibase.database.structure.type.FloatType;
import liquibase.database.structure.type.IntType;
import liquibase.database.structure.type.NVarcharType;
import liquibase.database.structure.type.NumberType;
import liquibase.database.structure.type.SmallIntType;
import liquibase.database.structure.type.TimeType;
import liquibase.database.structure.type.TinyIntType;
import liquibase.database.structure.type.UUIDType;
import liquibase.database.structure.type.VarcharType;
import liquibase.database.typeconversion.TypeConverter;
import liquibase.exception.DateParseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.logging.LogFactory;
import liquibase.statement.DatabaseFunction;
import liquibase.util.StringUtils;

public abstract class AbstractTypeConverter
implements TypeConverter {
    public Object convertDatabaseValueToObject(Object value, int databaseDataType, int firstParameter, int secondParameter, Database database) throws ParseException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.convertToCorrectObjectType(((String)value).replaceFirst("^'", "").replaceFirst("'$", ""), databaseDataType, firstParameter, secondParameter, database);
        }
        return value;
    }

    public DataType getDataType(Object object) {
        if (object instanceof BigInteger) {
            return this.getBigIntType();
        }
        if (object instanceof Boolean) {
            return this.getBooleanType();
        }
        if (object instanceof String) {
            return this.getVarcharType();
        }
        if (object instanceof Date) {
            return this.getDateType();
        }
        if (object instanceof Timestamp) {
            return this.getDateTimeType();
        }
        if (object instanceof Time) {
            return this.getTimeType();
        }
        if (object instanceof java.util.Date) {
            return this.getDateTimeType();
        }
        if (object instanceof Double) {
            return this.getDoubleType();
        }
        if (object instanceof Float) {
            return this.getFloatType();
        }
        if (object instanceof Integer) {
            return this.getIntType();
        }
        if (object instanceof Long) {
            return this.getBigIntType();
        }
        if (object instanceof DatabaseFunction) {
            return new DatabaseFunctionType();
        }
        throw new UnexpectedLiquibaseException("Unknown object type " + object.getClass().getName());
    }

    protected Object convertToCorrectObjectType(String value, int dataType, int columnSize, int decimalDigits, Database database) throws ParseException {
        if (value == null) {
            return null;
        }
        if (dataType == 2005 || dataType == 12 || dataType == 1 || dataType == -1) {
            if (value.equalsIgnoreCase("NULL")) {
                return null;
            }
            return value;
        }
        if ((value = StringUtils.trimToNull(value)) == null) {
            return null;
        }
        try {
            if (dataType == 91) {
                return new Date(database.parseDate(value).getTime());
            }
            if (dataType == 93) {
                return new Timestamp(database.parseDate(value).getTime());
            }
            if (dataType == 92) {
                return new Time(database.parseDate(value).getTime());
            }
            if (dataType == -5) {
                return new BigInteger(value);
            }
            if (dataType == -7) {
                if ((value = value.replaceFirst("b'", "")).equalsIgnoreCase("true")) {
                    return Boolean.TRUE;
                }
                if (value.equalsIgnoreCase("false")) {
                    return Boolean.FALSE;
                }
                if (value.equals("1")) {
                    return Boolean.TRUE;
                }
                if (value.equals("0")) {
                    return Boolean.FALSE;
                }
                if (value.equals("(1)")) {
                    return Boolean.TRUE;
                }
                if (value.equals("(0)")) {
                    return Boolean.FALSE;
                }
                throw new ParseException("Unknown bit value: " + value, 0);
            }
            if (dataType == 16) {
                return Boolean.valueOf(value);
            }
            if (dataType == 3) {
                if (decimalDigits == 0) {
                    return new Integer(value);
                }
                return new BigDecimal(value);
            }
            if (dataType == 8 || dataType == 2) {
                return new BigDecimal(value);
            }
            if (dataType == 6) {
                return new Float(value);
            }
            if (dataType == 4) {
                return new Integer(value);
            }
            if (dataType == 0) {
                return null;
            }
            if (dataType == 7) {
                return new Float(value);
            }
            if (dataType == 5) {
                return new Integer(value);
            }
            if (dataType == -6) {
                return new Integer(value);
            }
            if (dataType == 2004) {
                return "!!!!!! LIQUIBASE CANNOT OUTPUT BLOB VALUES !!!!!!";
            }
            LogFactory.getLogger().warning("Do not know how to convert type " + dataType);
            return value;
        }
        catch (DateParseException e) {
            return new DatabaseFunction(value);
        }
        catch (NumberFormatException e) {
            return new DatabaseFunction(value);
        }
    }

    public DataType getDataType(String columnTypeString, Boolean autoIncrement) {
        String dataTypeName = null;
        String precision = null;
        if (columnTypeString.startsWith("java.sql.Types") && columnTypeString.contains("(")) {
            precision = columnTypeString.substring(columnTypeString.indexOf("(") + 1, columnTypeString.indexOf(")"));
            dataTypeName = columnTypeString.substring(columnTypeString.lastIndexOf(".") + 1, columnTypeString.indexOf("("));
        } else if (columnTypeString.startsWith("java.sql.Types")) {
            dataTypeName = columnTypeString.substring(columnTypeString.lastIndexOf(".") + 1);
        } else if (columnTypeString.contains("(")) {
            precision = columnTypeString.substring(columnTypeString.indexOf("(") + 1, columnTypeString.indexOf(")"));
            dataTypeName = columnTypeString.substring(0, columnTypeString.indexOf("("));
        } else {
            dataTypeName = columnTypeString;
        }
        return this.getDataType(columnTypeString, autoIncrement, dataTypeName, precision);
    }

    protected DataType getDataType(String columnTypeString, Boolean autoIncrement, String dataTypeName, String precision) {
        DataType returnTypeName = null;
        if (dataTypeName.equalsIgnoreCase("BIGINT")) {
            returnTypeName = this.getBigIntType();
        } else if (dataTypeName.equalsIgnoreCase("NUMBER")) {
            returnTypeName = this.getNumberType();
        } else if (dataTypeName.equalsIgnoreCase("BLOB")) {
            returnTypeName = this.getBlobType();
        } else if (dataTypeName.equalsIgnoreCase("BOOLEAN")) {
            returnTypeName = this.getBooleanType();
        } else if (dataTypeName.equalsIgnoreCase("CHAR")) {
            returnTypeName = this.getCharType();
        } else if (dataTypeName.equalsIgnoreCase("CLOB")) {
            returnTypeName = this.getClobType();
        } else if (dataTypeName.equalsIgnoreCase("CURRENCY")) {
            returnTypeName = this.getCurrencyType();
        } else if (dataTypeName.equalsIgnoreCase("DATE") || dataTypeName.equalsIgnoreCase(this.getDateType().getDataTypeName())) {
            returnTypeName = this.getDateType();
        } else if (dataTypeName.equalsIgnoreCase("DATETIME") || dataTypeName.equalsIgnoreCase(this.getDateTimeType().getDataTypeName())) {
            returnTypeName = this.getDateTimeType();
        } else if (dataTypeName.equalsIgnoreCase("DOUBLE")) {
            returnTypeName = this.getDoubleType();
        } else if (dataTypeName.equalsIgnoreCase("FLOAT")) {
            returnTypeName = this.getFloatType();
        } else if (dataTypeName.equalsIgnoreCase("INT")) {
            returnTypeName = this.getIntType();
        } else if (dataTypeName.equalsIgnoreCase("INTEGER")) {
            returnTypeName = this.getIntType();
        } else if (dataTypeName.equalsIgnoreCase("LONGVARBINARY")) {
            returnTypeName = this.getBlobType();
        } else if (dataTypeName.equalsIgnoreCase("LONGVARCHAR")) {
            returnTypeName = this.getClobType();
        } else if (dataTypeName.equalsIgnoreCase("SMALLINT")) {
            returnTypeName = this.getSmallIntType();
        } else if (dataTypeName.equalsIgnoreCase("TEXT")) {
            returnTypeName = this.getClobType();
        } else if (dataTypeName.equalsIgnoreCase("TIME") || dataTypeName.equalsIgnoreCase(this.getTimeType().getDataTypeName())) {
            returnTypeName = this.getTimeType();
        } else if (dataTypeName.toUpperCase().contains("TIMESTAMP")) {
            returnTypeName = this.getDateTimeType();
        } else if (dataTypeName.equalsIgnoreCase("TINYINT")) {
            returnTypeName = this.getTinyIntType();
        } else if (dataTypeName.equalsIgnoreCase("UUID")) {
            returnTypeName = this.getUUIDType();
        } else if (dataTypeName.equalsIgnoreCase("VARCHAR")) {
            returnTypeName = this.getVarcharType();
        } else if (dataTypeName.equalsIgnoreCase("NVARCHAR")) {
            returnTypeName = this.getNVarcharType();
        } else if (columnTypeString.startsWith("java.sql.Types")) {
            returnTypeName = this.getTypeFromMetaData(dataTypeName);
        } else {
            return new CustomType(columnTypeString, 0, 2);
        }
        if (returnTypeName == null) {
            throw new UnexpectedLiquibaseException("Could not determine " + dataTypeName + " for " + this.getClass().getName());
        }
        this.addPrecisionToType(precision, returnTypeName);
        return returnTypeName;
    }

    protected void addPrecisionToType(String precision, DataType returnTypeName) throws NumberFormatException {
        if (precision != null) {
            String[] params = precision.split(",");
            returnTypeName.setFirstParameter(params[0].trim());
            if (params.length > 1) {
                returnTypeName.setSecondParameter(params[1].trim());
            }
        }
    }

    private DataType getTypeFromMetaData(String dataTypeName) {
        return null;
    }

    public DataType getDataType(ColumnConfig columnConfig) {
        return this.getDataType(columnConfig.getType(), columnConfig.isAutoIncrement());
    }

    public DateType getDateType() {
        return new DateType();
    }

    public TimeType getTimeType() {
        return new TimeType();
    }

    public DateTimeType getDateTimeType() {
        return new DateTimeType();
    }

    public BigIntType getBigIntType() {
        return new BigIntType();
    }

    public CharType getCharType() {
        return new CharType();
    }

    public VarcharType getVarcharType() {
        return new VarcharType();
    }

    public NVarcharType getNVarcharType() {
        return new NVarcharType();
    }

    public FloatType getFloatType() {
        return new FloatType();
    }

    public DoubleType getDoubleType() {
        return new DoubleType();
    }

    public IntType getIntType() {
        return new IntType();
    }

    public TinyIntType getTinyIntType() {
        return new TinyIntType();
    }

    public SmallIntType getSmallIntType() {
        return new SmallIntType();
    }

    public BooleanType getBooleanType() {
        return new BooleanType();
    }

    public NumberType getNumberType() {
        return new NumberType();
    }

    public CurrencyType getCurrencyType() {
        return new CurrencyType();
    }

    public UUIDType getUUIDType() {
        return new UUIDType();
    }

    public ClobType getClobType() {
        return new ClobType();
    }

    public BlobType getBlobType() {
        return new BlobType();
    }

    public String convertToDatabaseTypeString(Column referenceColumn, Database database) {
        String dataType;
        List<Integer> noParens = Arrays.asList(2003, -5, -2, -7, 2004, 16, 2005, 70, 91, 2001, 4, 2000, -4, 0, 1111, 2006, 5, 2002, 92, 93, -6, -1);
        List<Integer> oneParam = Arrays.asList(1, -15, 12, -9, -3, 8, 6);
        List<Integer> twoParams = Arrays.asList(3, 2, 7);
        String translatedTypeName = referenceColumn.getTypeName();
        if (database instanceof PostgresDatabase && "bpchar".equals(translatedTypeName)) {
            translatedTypeName = "char";
        }
        if ((database instanceof HsqlDatabase || database instanceof H2Database || database instanceof DerbyDatabase || database instanceof DB2Database) && (referenceColumn.getDataType() == 6 || referenceColumn.getDataType() == 8)) {
            return "float";
        }
        if (database instanceof InformixDatabase) {
            if (translatedTypeName.toUpperCase().startsWith("INTERVAL")) {
                return translatedTypeName;
            }
            if (referenceColumn.getDataType() == 7) {
                return "SMALLFLOAT";
            }
        }
        if (noParens.contains(referenceColumn.getDataType())) {
            dataType = translatedTypeName;
        } else if (oneParam.contains(referenceColumn.getDataType())) {
            if (database instanceof PostgresDatabase && translatedTypeName.equalsIgnoreCase("TEXT")) {
                return translatedTypeName;
            }
            if (database instanceof MSSQLDatabase && translatedTypeName.equals("uniqueidentifier")) {
                return translatedTypeName;
            }
            if (database instanceof MySQLDatabase && (translatedTypeName.startsWith("enum(") || translatedTypeName.startsWith("set("))) {
                return translatedTypeName;
            }
            if (database instanceof OracleDatabase && translatedTypeName.equals("VARCHAR2")) {
                return translatedTypeName + "(" + referenceColumn.getColumnSize() + " " + (Object)((Object)referenceColumn.getLengthSemantics()) + ")";
            }
            if (database instanceof MySQLDatabase && translatedTypeName.equalsIgnoreCase("DOUBLE")) {
                return translatedTypeName;
            }
            dataType = translatedTypeName + "(" + referenceColumn.getColumnSize() + ")";
        } else if (twoParams.contains(referenceColumn.getDataType())) {
            if (database instanceof PostgresDatabase && referenceColumn.getColumnSize() == 131089) {
                dataType = "DECIMAL";
            } else if (database instanceof MSSQLDatabase && translatedTypeName.toLowerCase().contains("money")) {
                dataType = translatedTypeName.toUpperCase();
            } else {
                dataType = translatedTypeName;
                if (referenceColumn.isInitPrecision()) {
                    dataType = dataType + "(" + referenceColumn.getColumnSize() + "," + referenceColumn.getDecimalDigits() + ")";
                }
            }
        } else {
            LogFactory.getLogger().warning("Unknown Data Type: " + referenceColumn.getDataType() + " (" + referenceColumn.getTypeName() + ").  Assuming it does not take parameters");
            dataType = referenceColumn.getTypeName();
        }
        return dataType;
    }
}

