/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    public static String trimToEmpty(String string) {
        if (string == null) {
            return "";
        }
        return string.trim();
    }

    public static String trimToNull(String string) {
        if (string == null) {
            return null;
        }
        String returnString = string.trim();
        if (returnString.length() == 0) {
            return null;
        }
        return returnString;
    }

    public static String[] processMutliLineSQL(String multiLineSQL, boolean stripComments, boolean splitStatements, String endDelimiter) {
        String stripped;
        String string = stripped = stripComments ? StringUtils.stripComments(multiLineSQL) : multiLineSQL;
        if (splitStatements) {
            return StringUtils.splitSQL(stripped, endDelimiter);
        }
        return new String[]{stripped};
    }

    public static String[] splitSQL(String multiLineSQL, String endDelimiter) {
        if (endDelimiter == null) {
            endDelimiter = ";\\s*\n|;$|\n[gG][oO]\\s*\n|\n[Gg][oO]\\s*$";
        }
        String[] strings = multiLineSQL.split(endDelimiter);
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = strings[i].trim();
        }
        return strings;
    }

    public static String stripComments(String multiLineSQL) {
        String strippedSingleLines = Pattern.compile("(.*?)\\s*\\-\\-.*\n").matcher(multiLineSQL).replaceAll("$1\n");
        strippedSingleLines = Pattern.compile("(.*?)\\s*\\-\\-.*$").matcher(strippedSingleLines).replaceAll("$1\n");
        return Pattern.compile("/\\*.*?\\*/", 32).matcher(strippedSingleLines).replaceAll("").trim();
    }

    public static String join(String[] array, String delimiter) {
        return StringUtils.join(Arrays.asList(array), delimiter);
    }

    public static String join(Collection<String> collection, String delimiter) {
        if (collection == null) {
            return null;
        }
        if (collection.size() == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (String val : collection) {
            buffer.append(val).append(delimiter);
        }
        String returnString = buffer.toString();
        return returnString.substring(0, returnString.length() - delimiter.length());
    }

    public static List<String> splitAndTrim(String s, String regex) {
        if (s == null) {
            return null;
        }
        ArrayList<String> returnList = new ArrayList<String>();
        for (String string : s.split(regex)) {
            returnList.add(string.trim());
        }
        return returnList;
    }

    public static String repeat(String string, int times) {
        String returnString = "";
        for (int i = 0; i < times; ++i) {
            returnString = returnString + string;
        }
        return returnString;
    }
}

