/*
 * Decompiled with CFR 0.152.
 */
package liquibase.servicelocator;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.Manifest;
import liquibase.exception.ServiceNotFoundException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.logging.Logger;
import liquibase.logging.core.DefaultLogger;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.servicelocator.DefaultPackageScanClassResolver;
import liquibase.servicelocator.LiquibaseService;
import liquibase.servicelocator.PackageScanClassResolver;
import liquibase.servicelocator.PrioritizedService;
import liquibase.servicelocator.WebSpherePackageScanClassResolver;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceLocator {
    private static ServiceLocator instance;
    private ResourceAccessor resourceAccessor;
    private Map<Class, List<Class>> classesBySuperclass;
    private List<String> packagesToScan;
    private Logger logger = new DefaultLogger();
    private PackageScanClassResolver classResolver;

    private ServiceLocator() {
        this.setResourceAccessor(new ClassLoaderResourceAccessor());
    }

    private ServiceLocator(ResourceAccessor accessor) {
        this.setResourceAccessor(accessor);
    }

    public static ServiceLocator getInstance() {
        return instance;
    }

    public void setResourceAccessor(ResourceAccessor resourceAccessor) {
        this.resourceAccessor = resourceAccessor;
        this.classesBySuperclass = new HashMap<Class, List<Class>>();
        if (WebSpherePackageScanClassResolver.isWebSphereClassLoader(this.getClass().getClassLoader())) {
            this.logger.debug("Using WebSphere Specific Class Resolver");
            this.classResolver = new WebSpherePackageScanClassResolver("liquibase/parser/core/xml/dbchangelog-2.0.xsd");
        } else {
            this.classResolver = new DefaultPackageScanClassResolver();
        }
        this.classResolver.setClassLoaders(new HashSet<ClassLoader>(Arrays.asList(resourceAccessor.toClassLoader())));
        this.packagesToScan = new ArrayList<String>();
        String packagesToScanSystemProp = System.getProperty("liquibase.scan.packages");
        if (packagesToScanSystemProp != null && (packagesToScanSystemProp = StringUtils.trimToNull(packagesToScanSystemProp)) != null) {
            for (String value : packagesToScanSystemProp.split(",")) {
                this.addPackageToScan(value);
            }
        } else {
            Enumeration<URL> manifests = null;
            try {
                manifests = resourceAccessor.getResources("META-INF/MANIFEST.MF");
                while (manifests.hasMoreElements()) {
                    URL url = manifests.nextElement();
                    InputStream is = url.openStream();
                    Manifest manifest = new Manifest(is);
                    String attributes = StringUtils.trimToNull(manifest.getMainAttributes().getValue("Liquibase-Package"));
                    if (attributes != null) {
                        for (String value : attributes.split(",")) {
                            this.addPackageToScan(value.toString());
                        }
                    }
                    is.close();
                }
            }
            catch (IOException e) {
                throw new UnexpectedLiquibaseException(e);
            }
            if (this.packagesToScan.size() == 0) {
                this.addPackageToScan("liquibase.change");
                this.addPackageToScan("liquibase.database");
                this.addPackageToScan("liquibase.parser");
                this.addPackageToScan("liquibase.precondition");
                this.addPackageToScan("liquibase.serializer");
                this.addPackageToScan("liquibase.sqlgenerator");
                this.addPackageToScan("liquibase.executor");
                this.addPackageToScan("liquibase.snapshot");
                this.addPackageToScan("liquibase.logging");
                this.addPackageToScan("liquibase.ext");
            }
        }
    }

    public void addPackageToScan(String packageName) {
        this.packagesToScan.add(packageName);
    }

    public Class findClass(Class requiredInterface) throws ServiceNotFoundException {
        Class[] classes = this.findClasses(requiredInterface);
        if (PrioritizedService.class.isAssignableFrom(requiredInterface)) {
            Object returnObject = null;
            for (Class clazz : classes) {
                PrioritizedService newInstance;
                try {
                    newInstance = (PrioritizedService)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new UnexpectedLiquibaseException(e);
                }
                if (returnObject != null && newInstance.getPriority() <= returnObject.getPriority()) continue;
                returnObject = newInstance;
            }
            if (returnObject == null) {
                throw new ServiceNotFoundException("Could not find implementation of " + requiredInterface.getName());
            }
            return returnObject.getClass();
        }
        if (classes.length != 1) {
            throw new ServiceNotFoundException("Could not find unique implementation of " + requiredInterface.getName() + ".  Found " + classes.length + " implementations");
        }
        return classes[0];
    }

    public Class[] findClasses(Class requiredInterface) throws ServiceNotFoundException {
        this.logger.debug("ServiceLocator.findClasses for " + requiredInterface.getName());
        try {
            Class.forName(requiredInterface.getName());
            if (!this.classesBySuperclass.containsKey(requiredInterface)) {
                this.classesBySuperclass.put(requiredInterface, this.findClassesImpl(requiredInterface));
            }
        }
        catch (Exception e) {
            throw new ServiceNotFoundException(e);
        }
        List<Class> classes = this.classesBySuperclass.get(requiredInterface);
        HashSet<Class> uniqueClasses = new HashSet<Class>(classes);
        return uniqueClasses.toArray(new Class[uniqueClasses.size()]);
    }

    public Object newInstance(Class requiredInterface) throws ServiceNotFoundException {
        try {
            return this.findClass(requiredInterface).newInstance();
        }
        catch (Exception e) {
            throw new ServiceNotFoundException(e);
        }
    }

    private List<Class> findClassesImpl(Class requiredInterface) throws Exception {
        this.logger.debug("ServiceLocator finding classes matching interface " + requiredInterface.getName());
        ArrayList<Class> classes = new ArrayList<Class>();
        this.classResolver.addClassLoader(this.resourceAccessor.toClassLoader());
        for (Class<?> clazz : this.classResolver.findImplementations(requiredInterface, this.packagesToScan.toArray(new String[this.packagesToScan.size()]))) {
            if (clazz.getAnnotation(LiquibaseService.class) != null && clazz.getAnnotation(LiquibaseService.class).skip() || Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers()) || !Modifier.isPublic(clazz.getModifiers())) continue;
            try {
                clazz.getConstructor(new Class[0]);
                this.logger.debug(clazz.getName() + " matches " + requiredInterface.getName());
                classes.add(clazz);
            }
            catch (NoSuchMethodException e) {
                this.logger.info("Can not use " + clazz + " as a Liquibase service because it does not have a default constructor");
            }
        }
        return classes;
    }

    public static void reset() {
        instance = new ServiceLocator();
    }

    protected Logger getLogger() {
        return this.logger;
    }

    static {
        try {
            Class<?> scanner = Class.forName("Liquibase.ServiceLocator.ClrServiceLocator, Liquibase");
            instance = (ServiceLocator)scanner.newInstance();
        }
        catch (Exception e) {
            instance = new ServiceLocator();
        }
    }
}

