/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.core.DropPrimaryKeyChange;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.AddPrimaryKeyStatement;
import liquibase.statement.core.ReorganizeTableStatement;

@DatabaseChange(name="addPrimaryKey", description="Adds creates a primary key out of an existing column or set of columns.", priority=1, appliesTo={"column"})
public class AddPrimaryKeyChange
extends AbstractChange {
    private String catalogName;
    private String schemaName;
    private String tableName;
    private String tablespace;
    private String columnNames;
    private String constraintName;

    @DatabaseChangeProperty(mustEqualExisting="column.relation", description="Name of the table to create the primary key on")
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @DatabaseChangeProperty(mustEqualExisting="column.relation.catalog", since="3.0")
    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @DatabaseChangeProperty(mustEqualExisting="column.relation.schema")
    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @DatabaseChangeProperty(mustEqualExisting="column", description="Name of the column(s) to create the primary key on. Comma separated if multiple")
    public String getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String columnNames) {
        this.columnNames = columnNames;
    }

    @DatabaseChangeProperty(description="Name of primary key constraint", exampleValue="pk_person")
    public String getConstraintName() {
        return this.constraintName;
    }

    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(String tablespace) {
        this.tablespace = tablespace;
    }

    public SqlStatement[] generateStatements(Database database) {
        AddPrimaryKeyStatement statement = new AddPrimaryKeyStatement(this.getCatalogName(), this.getSchemaName(), this.getTableName(), this.getColumnNames(), this.getConstraintName());
        statement.setTablespace(this.getTablespace());
        if (database instanceof DB2Database) {
            return new SqlStatement[]{statement, new ReorganizeTableStatement(this.getCatalogName(), this.getSchemaName(), this.getTableName())};
        }
        return new SqlStatement[]{statement};
    }

    protected Change[] createInverses() {
        DropPrimaryKeyChange inverse = new DropPrimaryKeyChange();
        inverse.setSchemaName(this.getSchemaName());
        inverse.setTableName(this.getTableName());
        inverse.setConstraintName(this.getConstraintName());
        return new Change[]{inverse};
    }

    public String getConfirmationMessage() {
        return "Primary key added to " + this.getTableName() + " (" + this.getColumnNames() + ")";
    }
}

