/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.core.DropUniqueConstraintChange;
import liquibase.database.Database;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.AddUniqueConstraintStatement;

@DatabaseChange(name="addUniqueConstraint", description="Adds a unique constrant to an existing column or set of columns.", priority=1, appliesTo={"column"})
public class AddUniqueConstraintChange
extends AbstractChange {
    private String catalogName;
    private String schemaName;
    private String tableName;
    private String columnNames;
    private String constraintName;
    private String tablespace;
    private Boolean deferrable;
    private Boolean initiallyDeferred;
    private Boolean disabled;

    @DatabaseChangeProperty(mustEqualExisting="column.relation.catalog", since="3.0")
    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @DatabaseChangeProperty(mustEqualExisting="column.relation.schema")
    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @DatabaseChangeProperty(mustEqualExisting="column.relation", description="Name of the table to create the unique constraint on")
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @DatabaseChangeProperty(mustEqualExisting="column", description="Name of the column(s) to create the unique constraint on. Comma separated if multiple")
    public String getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String columnNames) {
        this.columnNames = columnNames;
    }

    @DatabaseChangeProperty(description="Name of the unique constraint")
    public String getConstraintName() {
        return this.constraintName;
    }

    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    @DatabaseChangeProperty(description="'Tablespace' to create the index in. Corresponds to file group in mssql")
    public String getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(String tablespace) {
        this.tablespace = tablespace;
    }

    public Boolean getDeferrable() {
        return this.deferrable;
    }

    public void setDeferrable(Boolean deferrable) {
        this.deferrable = deferrable;
    }

    public Boolean getInitiallyDeferred() {
        return this.initiallyDeferred;
    }

    public void setInitiallyDeferred(Boolean initiallyDeferred) {
        this.initiallyDeferred = initiallyDeferred;
    }

    public Boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public SqlStatement[] generateStatements(Database database) {
        boolean deferrable = false;
        if (this.getDeferrable() != null) {
            deferrable = this.getDeferrable();
        }
        boolean initiallyDeferred = false;
        if (this.getInitiallyDeferred() != null) {
            initiallyDeferred = this.getInitiallyDeferred();
        }
        boolean disabled = false;
        if (this.getDisabled() != null) {
            disabled = this.getDisabled();
        }
        AddUniqueConstraintStatement statement = new AddUniqueConstraintStatement(this.getCatalogName(), this.getSchemaName(), this.getTableName(), this.getColumnNames(), this.getConstraintName());
        statement.setTablespace(this.getTablespace()).setDeferrable(deferrable).setInitiallyDeferred(initiallyDeferred).setDisabled(disabled);
        return new SqlStatement[]{statement};
    }

    public String getConfirmationMessage() {
        return "Unique constraint added to " + this.getTableName() + "(" + this.getColumnNames() + ")";
    }

    protected Change[] createInverses() {
        DropUniqueConstraintChange inverse = new DropUniqueConstraintChange();
        inverse.setSchemaName(this.getSchemaName());
        inverse.setTableName(this.getTableName());
        inverse.setConstraintName(this.getConstraintName());
        return new Change[]{inverse};
    }
}

