/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.database.Database;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.TagDatabaseStatement;

@DatabaseChange(name="tagDatabase", description="Applies a tag to the database for future rollback", priority=1, since="1.6")
public class TagDatabaseChange
extends AbstractChange {
    private String tag;

    @DatabaseChangeProperty(description="Tag to apply", exampleValue="version_1.3")
    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new TagDatabaseStatement(this.tag)};
    }

    public String getConfirmationMessage() {
        return "Tag '" + this.tag + "' applied to database";
    }

    protected Change[] createInverses() {
        return new Change[0];
    }
}

