/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog.visitor;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.DatabaseHistoryException;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ResourceAccessor;
import liquibase.structure.DatabaseObject;
import liquibase.util.StreamUtil;

public class DBDocVisitor
implements ChangeSetVisitor {
    private Database database;
    private SortedSet<ChangeLogInfo> changeLogs;
    private Map<DatabaseObject, List<Change>> changesByObject;
    private Map<String, List<Change>> changesByAuthor;
    private Map<DatabaseObject, List<Change>> changesToRunByObject;
    private Map<String, List<Change>> changesToRunByAuthor;
    private List<Change> changesToRun;
    private List<Change> recentChanges;
    private String rootChangeLogName;
    private DatabaseChangeLog rootChangeLog;
    private static final int MAX_RECENT_CHANGE = 50;

    public DBDocVisitor(Database database) {
        this.database = database;
        this.changesByObject = new HashMap<DatabaseObject, List<Change>>();
        this.changesByAuthor = new HashMap<String, List<Change>>();
        this.changeLogs = new TreeSet<ChangeLogInfo>();
        this.changesToRunByObject = new HashMap<DatabaseObject, List<Change>>();
        this.changesToRunByAuthor = new HashMap<String, List<Change>>();
        this.changesToRun = new ArrayList<Change>();
        this.recentChanges = new ArrayList<Change>();
    }

    public ChangeSetVisitor.Direction getDirection() {
        return ChangeSetVisitor.Direction.FORWARD;
    }

    public void visit(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database) throws LiquibaseException {
        ChangeSet.RunStatus runStatus = this.database.getRunStatus(changeSet);
        if (this.rootChangeLogName == null) {
            this.rootChangeLogName = changeSet.getFilePath();
        }
        if (this.rootChangeLog == null) {
            this.rootChangeLog = databaseChangeLog;
        }
        if (!this.changesByAuthor.containsKey(changeSet.getAuthor())) {
            this.changesByAuthor.put(changeSet.getAuthor(), new ArrayList());
        }
        if (!this.changesToRunByAuthor.containsKey(changeSet.getAuthor())) {
            this.changesToRunByAuthor.put(changeSet.getAuthor(), new ArrayList());
        }
        boolean toRun = runStatus.equals((Object)ChangeSet.RunStatus.NOT_RAN) || runStatus.equals((Object)ChangeSet.RunStatus.RUN_AGAIN);
        for (Change change : changeSet.getChanges()) {
            if (toRun) {
                this.changesToRunByAuthor.get(changeSet.getAuthor()).add(change);
                this.changesToRun.add(change);
                continue;
            }
            this.changesByAuthor.get(changeSet.getAuthor()).add(change);
            this.recentChanges.add(0, change);
        }
        ChangeLogInfo changeLogInfo = new ChangeLogInfo(changeSet.getFilePath(), databaseChangeLog.getPhysicalFilePath());
        if (!this.changeLogs.contains(changeLogInfo)) {
            this.changeLogs.add(changeLogInfo);
        }
        for (Change change : changeSet.getChanges()) {
            Set<DatabaseObject> affectedDatabaseObjects = change.getAffectedDatabaseObjects(database);
            if (affectedDatabaseObjects == null) continue;
            for (DatabaseObject dbObject : affectedDatabaseObjects) {
                if (toRun) {
                    if (!this.changesToRunByObject.containsKey(dbObject)) {
                        this.changesToRunByObject.put(dbObject, new ArrayList());
                    }
                    this.changesToRunByObject.get(dbObject).add(change);
                }
                if (!this.changesByObject.containsKey(dbObject)) {
                    this.changesByObject.put(dbObject, new ArrayList());
                }
                this.changesByObject.get(dbObject).add(change);
            }
        }
    }

    public void writeHTML(File rootOutputDir, ResourceAccessor resourceAccessor) throws IOException, DatabaseException, DatabaseHistoryException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(String fileToCopy, File rootOutputDir) throws IOException {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(fileToCopy);
        FileOutputStream outputStream = null;
        try {
            if (inputStream == null) {
                throw new IOException("Can not find " + fileToCopy);
            }
            outputStream = new FileOutputStream(new File(rootOutputDir, fileToCopy.replaceFirst(".*\\/", "")), false);
            StreamUtil.copy(inputStream, outputStream);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChangeLogInfo
    implements Comparable<ChangeLogInfo> {
        public String logicalPath;
        public String physicalPath;

        private ChangeLogInfo(String logicalPath, String physicalPath) {
            this.logicalPath = logicalPath;
            this.physicalPath = physicalPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChangeLogInfo that = (ChangeLogInfo)o;
            return this.logicalPath.equals(that.logicalPath);
        }

        public int hashCode() {
            return this.logicalPath.hashCode();
        }

        @Override
        public int compareTo(ChangeLogInfo o) {
            return this.logicalPath.compareTo(o.logicalPath);
        }

        public String toString() {
            return this.logicalPath;
        }
    }
}

