/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import java.math.BigInteger;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import liquibase.CatalogAndSchema;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.DatabaseConnection;
import liquibase.exception.DatabaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.logging.LogFactory;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.GetViewDefinitionStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Table;
import liquibase.structure.core.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SybaseDatabase
extends AbstractJdbcDatabase {
    public static final String PRODUCT_NAME = "Adaptive Server Enterprise";
    protected Set<String> systemTablesAndViews = new HashSet<String>();

    @Override
    public String getShortName() {
        return "sybase";
    }

    public SybaseDatabase() {
        super.setCurrentDateTimeFunction("GETDATE()");
        this.systemTablesAndViews.add("syscolumns");
        this.systemTablesAndViews.add("syscomments");
        this.systemTablesAndViews.add("sysdepends");
        this.systemTablesAndViews.add("sysfilegroups");
        this.systemTablesAndViews.add("sysfiles");
        this.systemTablesAndViews.add("sysfiles1");
        this.systemTablesAndViews.add("sysforeignkeys");
        this.systemTablesAndViews.add("sysfulltextcatalogs");
        this.systemTablesAndViews.add("sysfulltextnotify");
        this.systemTablesAndViews.add("sysindexes");
        this.systemTablesAndViews.add("sysindexkeys");
        this.systemTablesAndViews.add("sysmembers");
        this.systemTablesAndViews.add("sysobjects");
        this.systemTablesAndViews.add("syspermissions");
        this.systemTablesAndViews.add("sysproperties");
        this.systemTablesAndViews.add("sysprotects");
        this.systemTablesAndViews.add("sysreferences");
        this.systemTablesAndViews.add("systypes");
        this.systemTablesAndViews.add("sysusers");
        this.systemTablesAndViews.add("sysquerymetrics");
        this.systemTablesAndViews.add("syssegments");
        this.systemTablesAndViews.add("sysconstraints");
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public Integer getDefaultPort() {
        return 4100;
    }

    @Override
    protected String getDefaultDatabaseProductName() {
        return "Sybase";
    }

    @Override
    public boolean supportsDDLInTransaction() {
        return false;
    }

    @Override
    public Set<String> getSystemViews() {
        return this.systemTablesAndViews;
    }

    @Override
    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    @Override
    public boolean supportsSequences() {
        return false;
    }

    @Override
    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        String dbProductName = conn.getDatabaseProductName();
        return this.isSybaseProductName(dbProductName);
    }

    boolean isSybaseProductName(String dbProductName) {
        return PRODUCT_NAME.equals(dbProductName) || "Sybase SQL Server".equals(dbProductName) || "sql server".equals(dbProductName) || "ASE".equals(dbProductName);
    }

    @Override
    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:sybase")) {
            return "com.sybase.jdbc3.jdbc.SybDriver";
        }
        if (url.startsWith("jdbc:jtds:sybase")) {
            return "net.sourceforge.jtds.jdbc.Driver";
        }
        return null;
    }

    @Override
    protected String getAutoIncrementClause() {
        return "IDENTITY";
    }

    @Override
    protected boolean generateAutoIncrementStartWith(BigInteger startWith) {
        return false;
    }

    @Override
    protected boolean generateAutoIncrementBy(BigInteger incrementBy) {
        return false;
    }

    @Override
    public String getConcatSql(String ... values) {
        StringBuffer returnString = new StringBuffer();
        for (String value : values) {
            returnString.append(value).append(" + ");
        }
        return returnString.toString().replaceFirst(" \\+ $", "");
    }

    @Override
    public boolean supportsTablespaces() {
        return true;
    }

    @Override
    public boolean isSystemObject(DatabaseObject example) {
        if (example instanceof Table && (example.getSchema().getName().equals("sys") || example.getSchema().getName().equals("sybfi"))) {
            return true;
        }
        if (example instanceof View && (example.getSchema().getName().equals("sys") || example.getSchema().getName().equals("sybfi"))) {
            return true;
        }
        return super.isSystemObject(example);
    }

    public String generateDefaultConstraintName(String tableName, String columnName) {
        return "DF_" + tableName + "_" + columnName;
    }

    @Override
    public String getDefaultSchemaName() {
        return "dbo";
    }

    @Override
    public boolean supportsRestrictForeignKeys() {
        return false;
    }

    @Override
    public String escapeObjectName(String objectName, Class<? extends DatabaseObject> objectType) {
        return "[" + objectName + "]";
    }

    @Override
    public String getViewDefinition(CatalogAndSchema schema, String viewName) throws DatabaseException {
        schema = this.correctSchema(schema);
        GetViewDefinitionStatement statement = new GetViewDefinitionStatement(schema.getCatalogName(), schema.getSchemaName(), viewName);
        Executor executor = ExecutorService.getInstance().getExecutor(this);
        List definitionRows = executor.queryForList((SqlStatement)statement, String.class);
        StringBuilder definition = new StringBuilder();
        for (String d : definitionRows) {
            definition.append(d);
        }
        return definition.toString();
    }

    @Override
    public int getDatabaseMajorVersion() throws DatabaseException {
        try {
            return this.getConnection().getDatabaseMajorVersion();
        }
        catch (UnsupportedOperationException e) {
            LogFactory.getLogger().warning("Your JDBC driver does not support getDatabaseMajorVersion(). Consider upgrading it.");
            return -1;
        }
    }

    @Override
    public int getDatabaseMinorVersion() throws DatabaseException {
        try {
            return this.getConnection().getDatabaseMinorVersion();
        }
        catch (UnsupportedOperationException e) {
            LogFactory.getLogger().warning("Your JDBC driver does not support getDatabaseMajorVersion(). Consider upgrading it.");
            return -1;
        }
    }

    @Override
    public String escapeIndexName(String catalogName, String schemaName, String indexName) {
        return super.escapeIndexName(null, null, indexName);
    }
}

