/*
 * Decompiled with CFR 0.152.
 */
package liquibase.diff.compare;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import liquibase.database.Database;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.compare.DatabaseObjectComparator;
import liquibase.diff.compare.DatabaseObjectComparatorChain;
import liquibase.diff.compare.DatabaseObjectComparatorComparator;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.servicelocator.ServiceLocator;
import liquibase.structure.DatabaseObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseObjectComparatorFactory {
    private static DatabaseObjectComparatorFactory instance;
    private List<DatabaseObjectComparator> comparators = new ArrayList<DatabaseObjectComparator>();

    private DatabaseObjectComparatorFactory() {
        try {
            Class<DatabaseObjectComparator>[] classes;
            for (Class<DatabaseObjectComparator> clazz : classes = ServiceLocator.getInstance().findClasses(DatabaseObjectComparator.class)) {
                this.register(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    public static DatabaseObjectComparatorFactory getInstance() {
        if (instance == null) {
            instance = new DatabaseObjectComparatorFactory();
        }
        return instance;
    }

    public static void reset() {
        instance = new DatabaseObjectComparatorFactory();
    }

    public void register(DatabaseObjectComparator generator) {
        this.comparators.add(generator);
    }

    public void unregister(DatabaseObjectComparator generator) {
        this.comparators.remove(generator);
    }

    public void unregister(Class generatorClass) {
        DatabaseObjectComparator toRemove = null;
        for (DatabaseObjectComparator existingGenerator : this.comparators) {
            if (!existingGenerator.getClass().equals(generatorClass)) continue;
            toRemove = existingGenerator;
        }
        this.unregister(toRemove);
    }

    protected SortedSet<DatabaseObjectComparator> getComparators(Class<? extends DatabaseObject> comparatorClass, Database database) {
        TreeSet<DatabaseObjectComparator> validComparators = new TreeSet<DatabaseObjectComparator>(new DatabaseObjectComparatorComparator(comparatorClass, database));
        for (DatabaseObjectComparator comparator : this.comparators) {
            if (comparator.getPriority(comparatorClass, database) <= 0) continue;
            validComparators.add(comparator);
        }
        return validComparators;
    }

    public static void resetAll() {
        instance = null;
    }

    public boolean isSameObject(DatabaseObject object1, DatabaseObject object2, Database accordingTo) {
        return this.createComparatorChain(object1.getClass(), accordingTo).isSameObject(object1, object2, accordingTo);
    }

    public ObjectDifferences findDifferences(DatabaseObject object1, DatabaseObject object2, Database accordingTo) {
        return this.createComparatorChain(object1.getClass(), accordingTo).findDifferences(object1, object2, accordingTo);
    }

    private DatabaseObjectComparatorChain createComparatorChain(Class<? extends DatabaseObject> databaseObjectType, Database database) {
        SortedSet<DatabaseObjectComparator> comparators = DatabaseObjectComparatorFactory.getInstance().getComparators(databaseObjectType, database);
        if (comparators == null || comparators.size() == 0) {
            return null;
        }
        return new DatabaseObjectComparatorChain(comparators);
    }
}

