/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.ant;

import java.io.Writer;
import liquibase.Liquibase;
import liquibase.integration.ant.BaseLiquibaseTask;
import liquibase.util.ui.UIFactory;
import org.apache.tools.ant.BuildException;

public class DatabaseUpdateTask
extends BaseLiquibaseTask {
    private boolean dropFirst = false;

    public boolean isDropFirst() {
        return this.dropFirst;
    }

    public void setDropFirst(boolean dropFirst) {
        this.dropFirst = dropFirst;
    }

    public void execute() throws BuildException {
        if (!this.shouldRun()) {
            return;
        }
        super.execute();
        Liquibase liquibase = null;
        try {
            liquibase = this.createLiquibase();
            if (this.isPromptOnNonLocalDatabase() && !liquibase.isSafeToRunUpdate() && UIFactory.getInstance().getFacade().promptForNonLocalDatabase(liquibase.getDatabase())) {
                throw new BuildException("Chose not to run against non-production database");
            }
            Writer writer = this.createOutputWriter();
            if (writer == null) {
                if (this.isDropFirst()) {
                    liquibase.dropAll();
                }
                liquibase.update(this.getContexts());
            } else {
                if (this.isDropFirst()) {
                    throw new BuildException("Cannot dropFirst when outputting update SQL");
                }
                liquibase.update(this.getContexts(), writer);
                writer.flush();
                writer.close();
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            this.closeDatabase(liquibase);
        }
    }
}

