/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.cdi;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.Extension;
import javax.inject.Inject;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.integration.cdi.CDILiquibaseConfig;
import liquibase.integration.cdi.annotations.LiquibaseType;
import liquibase.logging.LogFactory;
import liquibase.logging.Logger;
import liquibase.resource.ResourceAccessor;
import liquibase.util.LiquibaseUtil;
import liquibase.util.NetUtil;

@ApplicationScoped
public class CDILiquibase
implements Extension {
    private Logger log = LogFactory.getLogger(CDILiquibase.class.getName());
    @Inject
    @LiquibaseType
    private CDILiquibaseConfig config;
    @Inject
    @LiquibaseType
    private DataSource dataSource;
    @Inject
    @LiquibaseType
    ResourceAccessor resourceAccessor;
    private boolean initialized = false;
    private boolean updateSuccessful = false;

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isUpdateSuccessful() {
        return this.updateSuccessful;
    }

    @PostConstruct
    public void onStartup() throws LiquibaseException {
        String hostName;
        this.log.info("Booting Liquibase " + LiquibaseUtil.getBuildVersion());
        try {
            hostName = NetUtil.getLocalHost().getHostName();
        }
        catch (Exception e) {
            this.log.warning("Cannot find hostname: " + e.getMessage());
            this.log.debug("", e);
            return;
        }
        String shouldRunProperty = System.getProperty("liquibase.should.run");
        if (shouldRunProperty != null && !Boolean.valueOf(shouldRunProperty).booleanValue()) {
            this.log.info("Liquibase did not run on " + hostName + " because '" + "liquibase.should.run" + "' system property was set to false");
            return;
        }
        this.initialized = true;
        this.performUpdate();
    }

    private void performUpdate() throws LiquibaseException {
        Connection c = null;
        Liquibase liquibase = null;
        try {
            c = this.dataSource.getConnection();
            liquibase = this.createLiquibase(c);
            liquibase.update(this.config.getContexts());
            this.updateSuccessful = true;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        catch (LiquibaseException ex) {
            this.updateSuccessful = false;
            throw ex;
        }
        finally {
            if (c != null) {
                try {
                    c.rollback();
                    c.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    protected Liquibase createLiquibase(Connection c) throws LiquibaseException {
        Liquibase liquibase = new Liquibase(this.config.getChangeLog(), this.resourceAccessor, this.createDatabase(c));
        if (this.config.getParameters() != null) {
            for (Map.Entry<String, String> entry : this.config.getParameters().entrySet()) {
                liquibase.setChangeLogParameter(entry.getKey(), entry.getValue());
            }
        }
        if (this.config.isDropFirst()) {
            liquibase.dropAll();
        }
        return liquibase;
    }

    protected Database createDatabase(Connection c) throws DatabaseException {
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation(new JdbcConnection(c));
        if (this.config.getDefaultSchema() != null) {
            database.setDefaultSchemaName(this.config.getDefaultSchema());
        }
        return database;
    }
}

