/*
 * Decompiled with CFR 0.152.
 */
package liquibase.snapshot;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import liquibase.logging.LogFactory;
import liquibase.servicelocator.ServiceLocator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnapshotControl {
    private Set<Class<? extends DatabaseObject>> types;
    private static Set<Class<? extends DatabaseObject>> defaultTypes;

    public SnapshotControl() {
        this.types = this.getDefaultTypes();
    }

    public SnapshotControl(Class<? extends DatabaseObject> ... types) {
        this.types = types == null || types.length == 0 ? this.getDefaultTypes() : new HashSet<Class<? extends DatabaseObject>>(Arrays.asList(types));
    }

    public SnapshotControl(String types) {
        this.types = this.readTypesString(types);
    }

    private Set<Class<? extends DatabaseObject>> readTypesString(String typesString) {
        Class<DatabaseObject>[] classes;
        if (StringUtils.trimToNull(typesString) == null) {
            return this.getDefaultTypes();
        }
        HashSet<Class<DatabaseObject>> returnSet = new HashSet<Class<DatabaseObject>>();
        HashSet<String> typesToInclude = new HashSet<String>(Arrays.asList(typesString.toLowerCase().split("\\s*,\\s*")));
        for (Class<DatabaseObject> clazz : classes = ServiceLocator.getInstance().findClasses(DatabaseObject.class)) {
            if (!typesToInclude.contains(clazz.getSimpleName().toLowerCase()) && !typesToInclude.contains(clazz.getSimpleName().toLowerCase() + "s")) continue;
            returnSet.add(clazz);
        }
        return null;
    }

    private Set<Class<? extends DatabaseObject>> getDefaultTypes() {
        if (defaultTypes == null) {
            Class<DatabaseObject>[] classes;
            HashSet<Class<? extends DatabaseObject>> set = new HashSet<Class<? extends DatabaseObject>>();
            for (Class<DatabaseObject> clazz : classes = ServiceLocator.getInstance().findClasses(DatabaseObject.class)) {
                try {
                    if (!clazz.newInstance().snapshotByDefault()) continue;
                    set.add(clazz);
                }
                catch (Exception e) {
                    LogFactory.getLogger().info("Cannot construct " + clazz.getName() + " to determine if it should be included in the snapshot by default");
                }
            }
            defaultTypes = set;
        }
        return defaultTypes;
    }

    public Set<Class<? extends DatabaseObject>> getTypesToInclude() {
        return this.types;
    }

    public boolean shouldInclude(Class<? extends DatabaseObject> type) {
        return type.equals(Catalog.class) || this.types.contains(type);
    }
}

