/*
 * Decompiled with CFR 0.152.
 */
package liquibase.snapshot.jvm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.core.InformixDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.diff.compare.DatabaseObjectComparatorFactory;
import liquibase.exception.DatabaseException;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.JdbcDatabaseSnapshot;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.snapshot.jvm.JdbcSnapshotGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Column;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.Index;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.structure.core.UniqueConstraint;

public class IndexSnapshotGenerator
extends JdbcSnapshotGenerator {
    public IndexSnapshotGenerator() {
        super(Index.class, new Class[]{Table.class, ForeignKey.class, UniqueConstraint.class});
    }

    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (!snapshot.getSnapshotControl().shouldInclude(Index.class)) {
            return;
        }
        if (foundObject instanceof Table) {
            Table table = (Table)foundObject;
            Database database = snapshot.getDatabase();
            Schema schema = table.getSchema();
            List<JdbcDatabaseSnapshot.CachedRow> rs = null;
            JdbcDatabaseSnapshot.CachingDatabaseMetaData databaseMetaData = null;
            try {
                databaseMetaData = ((JdbcDatabaseSnapshot)snapshot).getMetaData();
                if (database instanceof OracleDatabase) {
                    String sql = "SELECT INDEX_NAME, COLUMN_NAME FROM ALL_IND_COLUMNS WHERE TABLE_OWNER='" + schema.getName() + "' AND TABLE_NAME='" + table.getName() + "'";
                    rs = databaseMetaData.query(sql);
                } else {
                    rs = databaseMetaData.getIndexInfo(((AbstractJdbcDatabase)database).getJdbcCatalogName(schema), ((AbstractJdbcDatabase)database).getJdbcSchemaName(schema), table.getName(), false, true);
                }
                HashMap foundIndexes = new HashMap();
                for (JdbcDatabaseSnapshot.CachedRow row : rs) {
                    String indexName = row.getString("INDEX_NAME");
                    if (indexName == null) continue;
                    Index index = (Index)foundIndexes.get(indexName);
                    if (index == null) {
                        index = new Index();
                        index.setName(indexName);
                        index.setTable(table);
                    }
                    index.getColumns().add(row.getString("COLUMN_NAME"));
                }
                for (Index exampleIndex : foundIndexes.values()) {
                    table.getIndexes().add(exampleIndex);
                }
            }
            catch (Exception e) {
                throw new DatabaseException(e);
            }
        }
        if (foundObject instanceof UniqueConstraint && !(snapshot.getDatabase() instanceof DB2Database) && !(snapshot.getDatabase() instanceof DerbyDatabase)) {
            Index exampleIndex = new Index().setTable(((UniqueConstraint)foundObject).getTable()).setName(foundObject.getName());
            exampleIndex.getColumns().addAll(((UniqueConstraint)foundObject).getColumns());
            ((UniqueConstraint)foundObject).setBackingIndex(exampleIndex);
        }
    }

    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        Database database = snapshot.getDatabase();
        Table exampleTable = ((Index)example).getTable();
        for (int i = 0; i < ((Index)example).getColumns().size(); ++i) {
            ((Index)example).getColumns().set(i, database.correctObjectName(((Index)example).getColumns().get(i), Column.class));
        }
        Schema schema = new Schema(database.getDefaultCatalogName(), database.getDefaultSchemaName());
        String exampleName = example.getName();
        if (exampleName != null) {
            exampleName = database.correctObjectName(exampleName, Index.class);
        }
        ArrayList<Table> tables = new ArrayList<Table>();
        if (exampleTable.getName() == null) {
            DatabaseSnapshot tableSnapshot = SnapshotGeneratorFactory.getInstance().createSnapshot(schema.toCatalogAndSchema(), database, new SnapshotControl(Table.class, Schema.class, Catalog.class));
            tables.addAll(tableSnapshot.get(Table.class));
        } else {
            tables.add(exampleTable);
        }
        HashMap<String, Index> foundIndexes = new HashMap<String, Index>();
        for (Table table : tables) {
            JdbcDatabaseSnapshot.CachingDatabaseMetaData databaseMetaData = null;
            List<JdbcDatabaseSnapshot.CachedRow> rs = null;
            try {
                databaseMetaData = ((JdbcDatabaseSnapshot)snapshot).getMetaData();
                if (database instanceof OracleDatabase) {
                    String sql = "SELECT INDEX_NAME, 3 AS TYPE, TABLE_NAME, COLUMN_NAME, COLUMN_POSITION AS ORDINAL_POSITION, null AS FILTER_CONDITION FROM ALL_IND_COLUMNS WHERE TABLE_OWNER='" + schema.getName() + "' AND TABLE_NAME='" + table.getName() + "'";
                    if (exampleName != null) {
                        sql = sql + " AND INDEX_NAME='" + exampleName + "'";
                    }
                    sql = sql + " ORDER BY INDEX_NAME, ORDINAL_POSITION";
                    rs = databaseMetaData.query(sql);
                } else {
                    rs = databaseMetaData.getIndexInfo(((AbstractJdbcDatabase)database).getJdbcCatalogName(schema), ((AbstractJdbcDatabase)database).getJdbcSchemaName(schema), table.getName(), false, true);
                }
                for (JdbcDatabaseSnapshot.CachedRow row : rs) {
                    String indexName = database.correctObjectName(this.cleanNameFromDatabase(row.getString("INDEX_NAME"), database), Index.class);
                    if (indexName == null || (!database.isCaseSensitive() ? exampleName != null && !exampleName.equalsIgnoreCase(indexName) : exampleName != null && !exampleName.equals(indexName))) continue;
                    if (database instanceof InformixDatabase && indexName.startsWith(" ")) {
                        indexName = "_generated_index_" + indexName.substring(1);
                    }
                    short type = row.getShort("TYPE");
                    Boolean nonUnique = row.getBoolean("NON_UNIQUE");
                    if (nonUnique == null) {
                        nonUnique = true;
                    }
                    String columnName = this.cleanNameFromDatabase(row.getString("COLUMN_NAME"), database);
                    short position = row.getShort("ORDINAL_POSITION");
                    if (database instanceof InformixDatabase && type != 0 && position == 0) {
                        position = (short)(position + 1);
                        System.out.println(this.getClass().getName() + ": corrected position to " + position);
                    }
                    String filterCondition = row.getString("FILTER_CONDITION");
                    if (type == 0 || columnName == null) continue;
                    Index returnIndex = (Index)foundIndexes.get(indexName);
                    if (returnIndex == null) {
                        returnIndex = new Index();
                        returnIndex.setTable(table);
                        returnIndex.setName(indexName);
                        returnIndex.setUnique(nonUnique == false);
                        returnIndex.setFilterCondition(filterCondition);
                        foundIndexes.put(indexName, returnIndex);
                    }
                    for (int i = returnIndex.getColumns().size(); i < position; ++i) {
                        returnIndex.getColumns().add(null);
                    }
                    returnIndex.getColumns().set(position - 1, columnName);
                }
            }
            catch (Exception e) {
                throw new DatabaseException(e);
            }
        }
        if (exampleName != null) {
            return (DatabaseObject)foundIndexes.get(exampleName);
        }
        for (Index index : foundIndexes.values()) {
            if (!DatabaseObjectComparatorFactory.getInstance().isSameObject(index.getTable(), exampleTable, database) || !index.getColumnNames().equals(((Index)example).getColumnNames())) continue;
            return index;
        }
        return null;
    }
}

