/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import liquibase.database.Database;
import liquibase.database.core.InformixDatabase;
import liquibase.datatype.DataTypeFactory;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AddDefaultValueGenerator;
import liquibase.statement.core.AddDefaultValueStatement;
import liquibase.structure.core.Column;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;

public class AddDefaultValueGeneratorInformix
extends AddDefaultValueGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(AddDefaultValueStatement statement, Database database) {
        return database instanceof InformixDatabase;
    }

    public ValidationErrors validate(AddDefaultValueStatement addDefaultValueStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = super.validate(addDefaultValueStatement, database, sqlGeneratorChain);
        if (addDefaultValueStatement.getColumnDataType() == null) {
            validationErrors.checkRequiredField("columnDataType", addDefaultValueStatement.getColumnDataType());
        }
        return validationErrors;
    }

    public Sql[] generateSql(AddDefaultValueStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        Column column = new Column().setRelation(new Table().setName(statement.getTableName()).setSchema(new Schema(statement.getCatalogName(), statement.getSchemaName()))).setName(statement.getColumnName());
        Object defaultValue = statement.getDefaultValue();
        StringBuffer sql = new StringBuffer("ALTER TABLE ");
        sql.append(database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName()));
        sql.append(" MODIFY (");
        sql.append(database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), statement.getColumnName()));
        sql.append(" ");
        sql.append(DataTypeFactory.getInstance().fromDescription(statement.getColumnDataType()));
        sql.append(" DEFAULT ");
        sql.append(DataTypeFactory.getInstance().fromObject(defaultValue, database).objectToSql(defaultValue, database));
        sql.append(")");
        UnparsedSql unparsedSql = new UnparsedSql(sql.toString(), column);
        return new Sql[]{unparsedSql};
    }
}

