/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import liquibase.CatalogAndSchema;
import liquibase.database.Database;
import liquibase.database.core.MySQLDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.core.GetViewDefinitionStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetViewDefinitionGenerator
extends AbstractSqlGenerator<GetViewDefinitionStatement> {
    @Override
    public ValidationErrors validate(GetViewDefinitionStatement getViewDefinitionStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("viewName", getViewDefinitionStatement.getViewName());
        return validationErrors;
    }

    @Override
    public Sql[] generateSql(GetViewDefinitionStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        CatalogAndSchema schema = database.correctSchema(new CatalogAndSchema(statement.getCatalogName(), statement.getSchemaName()));
        String sql = "select view_definition from information_schema.views where table_name='" + database.correctObjectName(statement.getViewName(), View.class) + "'";
        if (database instanceof MySQLDatabase) {
            sql = sql + " and table_schema='" + schema.getCatalogName() + "'";
        } else {
            String catalogName;
            String schemaName;
            if (database.supportsSchemas() && (schemaName = schema.getSchemaName()) != null) {
                sql = sql + " and table_schema='" + schemaName + "'";
            }
            if (database.supportsCatalogs() && (catalogName = schema.getCatalogName()) != null) {
                sql = sql + " and table_catalog='" + catalogName + "'";
            }
        }
        return new Sql[]{new UnparsedSql(sql, new DatabaseObject[0])};
    }
}

