/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import liquibase.database.Database;
import liquibase.database.core.HsqlDatabase;
import liquibase.datatype.DataTypeFactory;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.InsertOrUpdateGenerator;
import liquibase.statement.core.InsertOrUpdateStatement;

public class InsertOrUpdateGeneratorHsql
extends InsertOrUpdateGenerator {
    public boolean supports(InsertOrUpdateStatement statement, Database database) {
        return database instanceof HsqlDatabase;
    }

    protected String getRecordCheck(InsertOrUpdateStatement insertOrUpdateStatement, Database database, String whereClause) {
        StringBuilder sql = new StringBuilder();
        sql.append("MERGE INTO ");
        sql.append(insertOrUpdateStatement.getTableName());
        sql.append(" USING (VALUES (1)) ON ");
        sql.append(whereClause);
        sql.append(" WHEN NOT MATCHED THEN ");
        return sql.toString();
    }

    protected String getInsertStatement(InsertOrUpdateStatement insertOrUpdateStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        StringBuilder columns = new StringBuilder();
        StringBuilder values = new StringBuilder();
        for (String columnKey : insertOrUpdateStatement.getColumnValues().keySet()) {
            columns.append(",");
            columns.append(columnKey);
            values.append(",");
            values.append(this.convertToString(insertOrUpdateStatement.getColumnValue(columnKey), database));
        }
        columns.deleteCharAt(0);
        values.deleteCharAt(0);
        return "INSERT (" + columns.toString() + ") VALUES (" + values.toString() + ")";
    }

    protected String getElse(Database database) {
        return " WHEN MATCHED THEN ";
    }

    protected String getUpdateStatement(InsertOrUpdateStatement insertOrUpdateStatement, Database database, String whereClause, SqlGeneratorChain sqlGeneratorChain) {
        StringBuilder sql = new StringBuilder("UPDATE SET ");
        String[] pkFields = insertOrUpdateStatement.getPrimaryKey().split(",");
        HashSet<String> hashPkFields = new HashSet<String>(Arrays.asList(pkFields));
        for (String columnKey : insertOrUpdateStatement.getColumnValues().keySet()) {
            if (hashPkFields.contains(columnKey)) continue;
            sql.append(columnKey).append(" = ");
            sql.append(this.convertToString(insertOrUpdateStatement.getColumnValue(columnKey), database));
            sql.append(",");
        }
        sql.deleteCharAt(sql.lastIndexOf(","));
        return sql.toString();
    }

    private String convertToString(Object newValue, Database database) {
        String sqlString = newValue == null || newValue.toString().equals("") || newValue.toString().equalsIgnoreCase("NULL") ? "NULL" : (newValue instanceof String && !this.looksLikeFunctionCall((String)newValue, database) ? "'" + database.escapeStringForDatabase(newValue.toString()) + "'" : (newValue instanceof Date ? database.getDateLiteral((Date)newValue) : (newValue instanceof Boolean ? (((Boolean)newValue).booleanValue() ? DataTypeFactory.getInstance().getTrueBooleanValue(database) : DataTypeFactory.getInstance().getFalseBooleanValue(database)) : newValue.toString())));
        return sqlString;
    }
}

