/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.util.ArrayList;
import java.util.Arrays;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.core.AddForeignKeyConstraintChange;
import liquibase.change.core.AddNotNullConstraintChange;
import liquibase.change.core.AddPrimaryKeyChange;
import liquibase.change.core.DropForeignKeyConstraintChange;
import liquibase.change.core.DropTableChange;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.InformixDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.SybaseASADatabase;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.statement.core.ReorganizeTableStatement;

@DatabaseChange(name="addLookupTable", description="Creates a lookup table containing values stored in a column and creates a foreign key to the new table.", priority=1, appliesTo={"column"})
public class AddLookupTableChange
extends AbstractChange {
    private String existingTableCatalogName;
    private String existingTableSchemaName;
    private String existingTableName;
    private String existingColumnName;
    private String newTableCatalogName;
    private String newTableSchemaName;
    private String newTableName;
    private String newColumnName;
    private String newColumnDataType;
    private String constraintName;

    public String getExistingTableCatalogName() {
        return this.existingTableCatalogName;
    }

    public void setExistingTableCatalogName(String existingTableCatalogName) {
        this.existingTableCatalogName = existingTableCatalogName;
    }

    @DatabaseChangeProperty(mustEqualExisting="column.relation.schema")
    public String getExistingTableSchemaName() {
        return this.existingTableSchemaName;
    }

    public void setExistingTableSchemaName(String existingTableSchemaName) {
        this.existingTableSchemaName = existingTableSchemaName;
    }

    @DatabaseChangeProperty(mustEqualExisting="column.relation", description="Name of the table containing the data to extract", exampleValue="address")
    public String getExistingTableName() {
        return this.existingTableName;
    }

    public void setExistingTableName(String existingTableName) {
        this.existingTableName = existingTableName;
    }

    @DatabaseChangeProperty(mustEqualExisting="column", description="Name of the column containing the data to extract", exampleValue="state")
    public String getExistingColumnName() {
        return this.existingColumnName;
    }

    public void setExistingColumnName(String existingColumnName) {
        this.existingColumnName = existingColumnName;
    }

    @DatabaseChangeProperty(since="3.0")
    public String getNewTableCatalogName() {
        return this.newTableCatalogName;
    }

    public void setNewTableCatalogName(String newTableCatalogName) {
        this.newTableCatalogName = newTableCatalogName;
    }

    public String getNewTableSchemaName() {
        return this.newTableSchemaName;
    }

    public void setNewTableSchemaName(String newTableSchemaName) {
        this.newTableSchemaName = newTableSchemaName;
    }

    @DatabaseChangeProperty(description="Name of lookup table to create", exampleValue="state")
    public String getNewTableName() {
        return this.newTableName;
    }

    public void setNewTableName(String newTableName) {
        this.newTableName = newTableName;
    }

    @DatabaseChangeProperty(description="Name of the column in the new table to create", exampleValue="abbreviation")
    public String getNewColumnName() {
        return this.newColumnName;
    }

    public void setNewColumnName(String newColumnName) {
        this.newColumnName = newColumnName;
    }

    @DatabaseChangeProperty(description="Data type of the new table column", exampleValue="char(2)")
    public String getNewColumnDataType() {
        return this.newColumnDataType;
    }

    public void setNewColumnDataType(String newColumnDataType) {
        this.newColumnDataType = newColumnDataType;
    }

    @DatabaseChangeProperty(description="Name of the foreign-key constraint to create between the existing table and the lookup table", exampleValue="fk_address_state")
    public String getConstraintName() {
        return this.constraintName;
    }

    public String getFinalConstraintName() {
        if (this.constraintName == null) {
            return ("FK_" + this.getExistingTableName() + "_" + this.getNewTableName()).toUpperCase();
        }
        return this.constraintName;
    }

    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    protected Change[] createInverses() {
        DropForeignKeyConstraintChange dropFK = new DropForeignKeyConstraintChange();
        dropFK.setBaseTableSchemaName(this.getExistingTableSchemaName());
        dropFK.setBaseTableName(this.getExistingTableName());
        dropFK.setConstraintName(this.getFinalConstraintName());
        DropTableChange dropTable = new DropTableChange();
        dropTable.setSchemaName(this.getNewTableSchemaName());
        dropTable.setTableName(this.getNewTableName());
        return new Change[]{dropFK, dropTable};
    }

    public SqlStatement[] generateStatements(Database database) {
        ArrayList<SqlStatement> statements = new ArrayList<SqlStatement>();
        String newTableCatalogName = this.getNewTableCatalogName();
        String newTableSchemaName = this.getNewTableSchemaName();
        String existingTableCatalogName = this.getExistingTableCatalogName() == null ? database.getDefaultCatalogName() : this.getExistingTableCatalogName();
        String existingTableSchemaName = this.getExistingTableSchemaName() == null ? database.getDefaultSchemaName() : this.getExistingTableSchemaName();
        SqlStatement[] createTablesSQL = new SqlStatement[]{new RawSqlStatement("CREATE TABLE " + database.escapeTableName(newTableCatalogName, newTableSchemaName, this.getNewTableName()) + " AS SELECT DISTINCT " + this.getExistingColumnName() + " AS " + this.getNewColumnName() + " FROM " + database.escapeTableName(existingTableCatalogName, existingTableSchemaName, this.getExistingTableName()) + " WHERE " + this.getExistingColumnName() + " IS NOT NULL")};
        if (database instanceof MSSQLDatabase) {
            createTablesSQL = new SqlStatement[]{new RawSqlStatement("SELECT DISTINCT " + this.getExistingColumnName() + " AS " + this.getNewColumnName() + " INTO " + database.escapeTableName(newTableCatalogName, newTableSchemaName, this.getNewTableName()) + " FROM " + database.escapeTableName(existingTableCatalogName, existingTableSchemaName, this.getExistingTableName()) + " WHERE " + this.getExistingColumnName() + " IS NOT NULL")};
        } else if (database instanceof SybaseASADatabase) {
            createTablesSQL = new SqlStatement[]{new RawSqlStatement("SELECT DISTINCT " + this.getExistingColumnName() + " AS " + this.getNewColumnName() + " INTO " + database.escapeTableName(newTableCatalogName, newTableSchemaName, this.getNewTableName()) + " FROM " + database.escapeTableName(existingTableCatalogName, existingTableSchemaName, this.getExistingTableName()) + " WHERE " + this.getExistingColumnName() + " IS NOT NULL")};
        } else if (database instanceof DB2Database) {
            createTablesSQL = new SqlStatement[]{new RawSqlStatement("CREATE TABLE " + database.escapeTableName(newTableCatalogName, newTableSchemaName, this.getNewTableName()) + " AS (SELECT " + this.getExistingColumnName() + " AS " + this.getNewColumnName() + " FROM " + database.escapeTableName(existingTableCatalogName, existingTableSchemaName, this.getExistingTableName()) + ") WITH NO DATA"), new RawSqlStatement("INSERT INTO " + database.escapeTableName(newTableCatalogName, newTableSchemaName, this.getNewTableName()) + " SELECT DISTINCT " + this.getExistingColumnName() + " FROM " + database.escapeTableName(existingTableCatalogName, existingTableSchemaName, this.getExistingTableName()) + " WHERE " + this.getExistingColumnName() + " IS NOT NULL")};
        } else if (database instanceof InformixDatabase) {
            createTablesSQL = new SqlStatement[]{new RawSqlStatement("CREATE TABLE " + database.escapeTableName(newTableCatalogName, newTableSchemaName, this.getNewTableName()) + " ( " + this.getNewColumnName() + " " + this.getNewColumnDataType() + " )"), new RawSqlStatement("INSERT INTO " + database.escapeTableName(newTableCatalogName, newTableSchemaName, this.getNewTableName()) + " ( " + this.getNewColumnName() + " ) SELECT DISTINCT " + this.getExistingColumnName() + " FROM " + database.escapeTableName(existingTableCatalogName, existingTableSchemaName, this.getExistingTableName()) + " WHERE " + this.getExistingColumnName() + " IS NOT NULL")};
        }
        statements.addAll(Arrays.asList(createTablesSQL));
        if (!(database instanceof OracleDatabase)) {
            AddNotNullConstraintChange addNotNullChange = new AddNotNullConstraintChange();
            addNotNullChange.setSchemaName(newTableSchemaName);
            addNotNullChange.setTableName(this.getNewTableName());
            addNotNullChange.setColumnName(this.getNewColumnName());
            addNotNullChange.setColumnDataType(this.getNewColumnDataType());
            statements.addAll(Arrays.asList(addNotNullChange.generateStatements(database)));
        }
        if (database instanceof DB2Database) {
            statements.add(new ReorganizeTableStatement(newTableCatalogName, newTableSchemaName, this.getNewTableName()));
        }
        AddPrimaryKeyChange addPKChange = new AddPrimaryKeyChange();
        addPKChange.setSchemaName(newTableSchemaName);
        addPKChange.setTableName(this.getNewTableName());
        addPKChange.setColumnNames(this.getNewColumnName());
        statements.addAll(Arrays.asList(addPKChange.generateStatements(database)));
        if (database instanceof DB2Database) {
            statements.add(new ReorganizeTableStatement(newTableCatalogName, newTableSchemaName, this.getNewTableName()));
        }
        AddForeignKeyConstraintChange addFKChange = new AddForeignKeyConstraintChange();
        addFKChange.setBaseTableSchemaName(existingTableSchemaName);
        addFKChange.setBaseTableName(this.getExistingTableName());
        addFKChange.setBaseColumnNames(this.getExistingColumnName());
        addFKChange.setReferencedTableSchemaName(newTableSchemaName);
        addFKChange.setReferencedTableName(this.getNewTableName());
        addFKChange.setReferencedColumnNames(this.getNewColumnName());
        addFKChange.setConstraintName(this.getFinalConstraintName());
        statements.addAll(Arrays.asList(addFKChange.generateStatements(database)));
        return statements.toArray(new SqlStatement[statements.size()]);
    }

    public String getConfirmationMessage() {
        return "Lookup table added for " + this.getExistingTableName() + "." + this.getExistingColumnName();
    }
}

