/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import liquibase.change.AbstractChange;
import liquibase.change.ChangeWithColumns;
import liquibase.change.CheckSum;
import liquibase.change.ColumnConfig;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.core.LoadDataColumnConfig;
import liquibase.database.Database;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.Warnings;
import liquibase.logging.LogFactory;
import liquibase.logging.Logger;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.InsertStatement;
import liquibase.util.StringUtils;
import liquibase.util.csv.CSVReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DatabaseChange(name="loadData", description="Loads data from a CSV file into an existing table. A value of NULL in a cell will be converted to a database NULL rather than the string 'NULL'\n\nDate/Time values included in the CSV file should be in ISO formathttp://en.wikipedia.org/wiki/ISO_8601 in order to be parsed correctly by Liquibase. Liquibase will initially set the date format to be 'yyyy-MM-dd'T'HH:mm:ss' and then it checks for two special cases which will override the data format string.\n\nIf the string representing the date/time includes a '.', then the date format is changed to 'yyyy-MM-dd'T'HH:mm:ss.SSS'\nIf the string representing the date/time includes a space, then the date format is changed to 'yyyy-MM-dd HH:mm:ss'\nOnce the date format string is set, Liquibase will then call the SimpleDateFormat.parse() method attempting to parse the input string so that it can return a Date/Time. If problems occur, then a ParseException is thrown and the input string is treated as a String for the INSERT command to be generated.", priority=1, appliesTo={"table"}, since="1.7")
public class LoadDataChange
extends AbstractChange
implements ChangeWithColumns<LoadDataColumnConfig> {
    private String catalogName;
    private String schemaName;
    private String tableName;
    private String file;
    private String encoding = null;
    private String separator = ",";
    private String quotchar = "\"";
    private List<LoadDataColumnConfig> columns = new ArrayList<LoadDataColumnConfig>();

    @Override
    public boolean supports(Database database) {
        return true;
    }

    @DatabaseChangeProperty(mustEqualExisting="table.catalog", since="3.0")
    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @DatabaseChangeProperty(mustEqualExisting="table.schema")
    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @DatabaseChangeProperty(mustEqualExisting="table", description="Name of the table to insert data into", requiredForDatabase={"all"})
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @DatabaseChangeProperty(description="CSV file to load", exampleValue="com/example/users.csv", requiredForDatabase={"all"})
    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    @DatabaseChangeProperty(exampleValue="UTF-8", description="Encoding of the CSV file (defaults to UTF-8)")
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        if (separator.equals("\\t")) {
            separator = "\t";
        }
        this.separator = separator;
    }

    public String getQuotchar() {
        return this.quotchar;
    }

    public void setQuotchar(String quotchar) {
        this.quotchar = quotchar;
    }

    @Override
    public void addColumn(LoadDataColumnConfig column) {
        this.columns.add(column);
    }

    @Override
    @DatabaseChangeProperty(description="Defines how the data should be loaded.", requiredForDatabase={"all"})
    public List<LoadDataColumnConfig> getColumns() {
        return this.columns;
    }

    @Override
    public SqlStatement[] generateStatements(Database database) {
        CSVReader reader = null;
        try {
            String[] line;
            reader = this.getCSVReader();
            String[] headers = reader.readNext();
            if (headers == null) {
                throw new UnexpectedLiquibaseException("Data file " + this.getFile() + " was empty");
            }
            ArrayList<InsertStatement> statements = new ArrayList<InsertStatement>();
            int lineNumber = 0;
            while ((line = reader.readNext()) != null) {
                ++lineNumber;
                if (line.length == 0 || line.length == 1 && StringUtils.trimToNull(line[0]) == null) continue;
                InsertStatement insertStatement = this.createStatement(this.getCatalogName(), this.getSchemaName(), this.getTableName());
                for (int i = 0; i < headers.length; ++i) {
                    String columnName = null;
                    if (i >= line.length) {
                        throw new UnexpectedLiquibaseException("CSV Line " + lineNumber + " has only " + (i - 1) + " columns, the header has " + headers.length);
                    }
                    Object value = line[i];
                    ColumnConfig columnConfig = this.getColumnConfig(i, headers[i]);
                    if (columnConfig != null) {
                        columnName = columnConfig.getName();
                        if ("skip".equalsIgnoreCase(columnConfig.getType())) continue;
                        if (value.toString().equalsIgnoreCase("NULL")) {
                            value = "NULL";
                        } else if (columnConfig.getType() != null) {
                            ColumnConfig valueConfig = new ColumnConfig();
                            if (columnConfig.getType().equalsIgnoreCase("BOOLEAN")) {
                                valueConfig.setValueBoolean(Boolean.parseBoolean(value.toString().toLowerCase()));
                            } else if (columnConfig.getType().equalsIgnoreCase("NUMERIC")) {
                                valueConfig.setValueNumeric(value.toString());
                            } else if (columnConfig.getType().toLowerCase().contains("date") || columnConfig.getType().toLowerCase().contains("time")) {
                                valueConfig.setValueDate(value.toString());
                            } else if (columnConfig.getType().equalsIgnoreCase("STRING")) {
                                valueConfig.setValue(value.toString());
                            } else if (columnConfig.getType().equalsIgnoreCase("COMPUTED")) {
                                valueConfig.setValue(value.toString());
                            } else {
                                throw new UnexpectedLiquibaseException("loadData type of " + columnConfig.getType() + " is not supported.  Please use BOOLEAN, NUMERIC, DATE, STRING, COMPUTED or SKIP");
                            }
                            value = valueConfig.getValueObject();
                        }
                    }
                    if (columnName == null) {
                        columnName = headers[i];
                    }
                    insertStatement.addColumnValue(columnName, value);
                }
                statements.add(insertStatement);
            }
            SqlStatement[] sqlStatementArray = statements.toArray(new SqlStatement[statements.size()]);
            return sqlStatementArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (UnexpectedLiquibaseException ule) {
            if (this.getChangeSet() != null && this.getChangeSet().getFailOnError() != null && !this.getChangeSet().getFailOnError().booleanValue()) {
                Logger log = LogFactory.getLogger();
                log.info("Change set " + this.getChangeSet().toString(false) + " failed, but failOnError was false.  Error: " + ule.getMessage());
                SqlStatement[] sqlStatementArray = new SqlStatement[]{};
                return sqlStatementArray;
            }
            throw ule;
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public boolean generateStatementsVolatile(Database database) {
        return false;
    }

    protected CSVReader getCSVReader() throws IOException {
        ResourceAccessor opener = this.getResourceAccessor();
        if (opener == null) {
            throw new UnexpectedLiquibaseException("No file opener specified for " + this.getFile());
        }
        InputStream stream = opener.getResourceAsStream(this.getFile());
        if (stream == null) {
            throw new UnexpectedLiquibaseException("Data file " + this.getFile() + " was not found");
        }
        InputStreamReader streamReader = this.getEncoding() == null ? new InputStreamReader(stream) : new InputStreamReader(stream, this.getEncoding());
        char quotchar = 0 == this.quotchar.length() ? (char)'\u0001' : this.quotchar.charAt(0);
        return new CSVReader(streamReader, this.separator.charAt(0), quotchar);
    }

    protected InsertStatement createStatement(String catalogName, String schemaName, String tableName) {
        return new InsertStatement(catalogName, schemaName, tableName);
    }

    protected ColumnConfig getColumnConfig(int index, String header) {
        for (LoadDataColumnConfig config : this.columns) {
            if (config.getIndex() != null && config.getIndex().equals(index)) {
                return config;
            }
            if (config.getHeader() != null && config.getHeader().equalsIgnoreCase(header)) {
                return config;
            }
            if (config.getName() == null || !config.getName().equalsIgnoreCase(header)) continue;
            return config;
        }
        return null;
    }

    @Override
    public String getConfirmationMessage() {
        return "Data loaded from " + this.getFile() + " into " + this.getTableName();
    }

    @Override
    public CheckSum generateCheckSum() {
        InputStream stream = null;
        try {
            stream = this.getResourceAccessor().getResourceAsStream(this.getFile());
            if (stream == null) {
                throw new RuntimeException(this.getFile() + " could not be found");
            }
            stream = new BufferedInputStream(stream);
            CheckSum checkSum = CheckSum.compute(stream, true);
            return checkSum;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public Warnings warn(Database database) {
        return null;
    }
}

