/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog.filter;

import java.util.ArrayList;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.database.Database;
import liquibase.database.DatabaseList;
import liquibase.sql.visitor.SqlVisitor;

public class DbmsChangeSetFilter
implements ChangeSetFilter {
    private Database database;

    public DbmsChangeSetFilter(Database database) {
        this.database = database;
    }

    public boolean accepts(ChangeSet changeSet) {
        if (this.database == null) {
            return true;
        }
        ArrayList<SqlVisitor> visitorsToRemove = new ArrayList<SqlVisitor>();
        for (SqlVisitor visitor : changeSet.getSqlVisitors()) {
            if (DatabaseList.definitionMatches(visitor.getApplicableDbms(), this.database, true)) continue;
            visitorsToRemove.add(visitor);
        }
        changeSet.getSqlVisitors().removeAll(visitorsToRemove);
        return DatabaseList.definitionMatches(changeSet.getDbmsSet(), this.database, true);
    }
}

