/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import liquibase.CatalogAndSchema;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.logging.LogFactory;
import liquibase.logging.Logger;
import liquibase.structure.DatabaseObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerbyDatabase
extends AbstractJdbcDatabase {
    private Logger log = LogFactory.getLogger();
    protected int driverVersionMajor;
    protected int driverVersionMinor;

    public DerbyDatabase() {
        super.setCurrentDateTimeFunction("CURRENT_TIMESTAMP");
        this.sequenceNextValueFunction = "NEXT VALUE FOR %s";
        this.sequenceCurrentValueFunction = "(SELECT currentvalue FROM sys.syssequences WHERE %s='SEQ_TYPE')";
        this.determineDriverVersion();
    }

    @Override
    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return "Apache Derby".equalsIgnoreCase(conn.getDatabaseProductName());
    }

    @Override
    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:derby://")) {
            return "org.apache.derby.jdbc.ClientDriver";
        }
        if (url.startsWith("jdbc:derby") || url.startsWith("java:derby")) {
            return "org.apache.derby.jdbc.EmbeddedDriver";
        }
        return null;
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public boolean supportsSchemas() {
        return false;
    }

    @Override
    public boolean jdbcCallsCatalogsSchemas() {
        return true;
    }

    @Override
    public Integer getDefaultPort() {
        return 1527;
    }

    @Override
    protected String getDefaultDatabaseProductName() {
        return "Derby";
    }

    @Override
    public String correctObjectName(String objectName, Class<? extends DatabaseObject> objectType) {
        if (objectName == null) {
            return null;
        }
        return objectName.toUpperCase();
    }

    @Override
    public String getShortName() {
        return "derby";
    }

    @Override
    public boolean supportsSequences() {
        return this.driverVersionMajor == 10 && this.driverVersionMinor >= 6 || this.driverVersionMajor >= 11;
    }

    @Override
    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    @Override
    public String getDateLiteral(String isoDate) {
        if (this.isDateOnly(isoDate)) {
            return "DATE(" + super.getDateLiteral(isoDate) + ")";
        }
        if (this.isTimeOnly(isoDate)) {
            return "TIME(" + super.getDateLiteral(isoDate) + ")";
        }
        String dateString = super.getDateLiteral(isoDate);
        int decimalDigits = dateString.length() - dateString.indexOf(46) - 2;
        String padding = "";
        for (int i = 6; i > decimalDigits; --i) {
            padding = padding + "0";
        }
        return "TIMESTAMP(" + dateString.replaceFirst("'$", padding + "'") + ")";
    }

    @Override
    public boolean supportsTablespaces() {
        return false;
    }

    @Override
    public String getViewDefinition(CatalogAndSchema schema, String name) throws DatabaseException {
        return super.getViewDefinition(schema, name).replaceFirst("CREATE VIEW \\w+ AS ", "");
    }

    @Override
    public void close() throws DatabaseException {
        String url = this.getConnection().getURL();
        String driverName = this.getDefaultDriver(url);
        super.close();
        if (driverName.toLowerCase().contains("embedded")) {
            try {
                url = url.contains(";") ? url.substring(0, url.indexOf(";")) + ";shutdown=true" : url + ";shutdown=true";
                LogFactory.getLogger().info("Shutting down derby connection: " + url);
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                Driver driver = (Driver)contextClassLoader.loadClass(driverName).newInstance();
                driver.connect(url, null);
            }
            catch (Exception e) {
                String state;
                if (e instanceof SQLException && ("XJ015".equals(state = ((SQLException)e).getSQLState()) || "08006".equals(state))) {
                    return;
                }
                throw new DatabaseException("Error closing derby cleanly", e);
            }
        }
    }

    protected void determineDriverVersion() {
        try {
            Enumeration<Driver> it = DriverManager.getDrivers();
            while (it.hasMoreElements()) {
                Driver driver = it.nextElement();
                if (!driver.getClass().getName().contains("derby")) continue;
                this.driverVersionMajor = driver.getMajorVersion();
                this.driverVersionMinor = driver.getMinorVersion();
                return;
            }
            this.log.debug("Unable to load/access Apache Derby driver class to check version");
            this.driverVersionMajor = -1;
            this.driverVersionMinor = -1;
        }
        catch (Exception e) {
            this.log.debug("Unable to load/access Apache Derby driver class org.apache.derby.tools.sysinfo to check version: " + e.getMessage());
            this.driverVersionMajor = -1;
            this.driverVersionMinor = -1;
        }
    }

    @Override
    protected String doGetDefaultCatalogName() throws DatabaseException {
        try {
            ResultSet resultSet = ((JdbcConnection)this.getConnection()).prepareStatement("select current schema from sysibm.sysdummy1").executeQuery();
            resultSet.next();
            return resultSet.getString(1);
        }
        catch (Exception e) {
            LogFactory.getLogger().info("Error getting default schema", e);
            return null;
        }
    }

    @Override
    public boolean supportsCatalogInObjectName(Class<? extends DatabaseObject> type) {
        return true;
    }
}

