/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import liquibase.CatalogAndSchema;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.logging.LogFactory;
import liquibase.statement.DatabaseFunction;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Index;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;

public class OracleDatabase
extends AbstractJdbcDatabase {
    public static final String PRODUCT_NAME = "oracle";
    private Set<String> reservedWords = new HashSet<String>();

    public OracleDatabase() {
        this.unquotedObjectsAreUppercased = true;
        super.setCurrentDateTimeFunction("SYSTIMESTAMP");
        this.dateFunctions.add(new DatabaseFunction("SYSDATE"));
        this.dateFunctions.add(new DatabaseFunction("SYSTIMESTAMP"));
        this.dateFunctions.add(new DatabaseFunction("CURRENT_TIMESTAMP"));
        this.sequenceNextValueFunction = "%s.nextval";
        this.sequenceCurrentValueFunction = "%s.currval";
    }

    public int getPriority() {
        return 1;
    }

    public void setConnection(DatabaseConnection conn) {
        try {
            Method wrappedConn = conn.getClass().getMethod("getWrappedConnection", new Class[0]);
            wrappedConn.setAccessible(true);
            Connection sqlConn = (Connection)wrappedConn.invoke((Object)conn, new Object[0]);
            Method method = sqlConn.getClass().getMethod("setRemarksReporting", Boolean.TYPE);
            method.setAccessible(true);
            method.invoke((Object)sqlConn, true);
            this.reservedWords.addAll(Arrays.asList(sqlConn.getMetaData().getSQLKeywords().toUpperCase().split(",\\s*")));
            this.reservedWords.addAll(Arrays.asList("USER", "SESSION", "RESOURCE", "START", "SIZE"));
        }
        catch (Exception e) {
            LogFactory.getLogger().info("Could not set remarks reporting on OracleDatabase: " + e.getMessage());
        }
        super.setConnection(conn);
    }

    public String getShortName() {
        return PRODUCT_NAME;
    }

    protected String getDefaultDatabaseProductName() {
        return "Oracle";
    }

    public Integer getDefaultPort() {
        return 1521;
    }

    public String getJdbcCatalogName(CatalogAndSchema schema) {
        return null;
    }

    public String getJdbcSchemaName(CatalogAndSchema schema) {
        return schema.getCatalogName();
    }

    public String generatePrimaryKeyName(String tableName) {
        if (tableName.length() > 27) {
            return "PK_" + tableName.toUpperCase().substring(0, 27);
        }
        return "PK_" + tableName.toUpperCase();
    }

    public boolean supportsInitiallyDeferrableColumns() {
        return true;
    }

    public boolean isReservedWord(String objectName) {
        return this.reservedWords.contains(objectName.toUpperCase());
    }

    public boolean supportsSequences() {
        return true;
    }

    public boolean supportsSchemas() {
        return false;
    }

    protected String doGetDefaultCatalogName() throws DatabaseException {
        try {
            ResultSet resultSet = ((JdbcConnection)this.getConnection()).prepareCall("select sys_context( 'userenv', 'current_schema' ) from dual").executeQuery();
            resultSet.next();
            return resultSet.getString(1);
        }
        catch (Exception e) {
            LogFactory.getLogger().info("Error getting default schema", e);
            return null;
        }
    }

    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return PRODUCT_NAME.equalsIgnoreCase(conn.getDatabaseProductName());
    }

    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:oracle")) {
            return "oracle.jdbc.OracleDriver";
        }
        return null;
    }

    public String getDefaultSchemaName() {
        return super.getDefaultSchemaName() == null ? null : super.getDefaultSchemaName().toUpperCase();
    }

    public String escapeIndexName(String catalogName, String schemaName, String indexName) {
        String escapedIndexName = this.escapeObjectName(indexName, Index.class);
        if (schemaName != null) {
            escapedIndexName = this.escapeObjectName(schemaName, Schema.class) + "." + escapedIndexName;
        }
        return escapedIndexName;
    }

    public String getDateLiteral(String isoDate) {
        String normalLiteral = super.getDateLiteral(isoDate);
        if (this.isDateOnly(isoDate)) {
            StringBuffer val = new StringBuffer();
            val.append("to_date(");
            val.append(normalLiteral);
            val.append(", 'YYYY-MM-DD')");
            return val.toString();
        }
        if (this.isTimeOnly(isoDate)) {
            StringBuffer val = new StringBuffer();
            val.append("to_date(");
            val.append(normalLiteral);
            val.append(", 'HH24:MI:SS')");
            return val.toString();
        }
        if (this.isDateTime(isoDate)) {
            normalLiteral = normalLiteral.substring(0, normalLiteral.lastIndexOf(46)) + "'";
            StringBuffer val = new StringBuffer(26);
            val.append("to_date(");
            val.append(normalLiteral);
            val.append(", 'YYYY-MM-DD HH24:MI:SS')");
            return val.toString();
        }
        return "UNSUPPORTED:" + isoDate;
    }

    public boolean isSystemObject(DatabaseObject example) {
        if (example == null) {
            return false;
        }
        if (example instanceof Schema) {
            if ("SYSTEM".equals(example.getName()) || "SYS".equals(example.getName()) || "CTXSYS".equals(example.getName()) || "XDB".equals(example.getName())) {
                return true;
            }
            if ("SYSTEM".equals(example.getSchema().getCatalogName()) || "SYS".equals(example.getSchema().getCatalogName()) || "CTXSYS".equals(example.getSchema().getCatalogName()) || "XDB".equals(example.getSchema().getCatalogName())) {
                return true;
            }
        } else if (this.isSystemObject(example.getSchema())) {
            return true;
        }
        if (example instanceof Catalog) {
            if ("SYSTEM".equals(example.getName()) || "SYS".equals(example.getName()) || "CTXSYS".equals(example.getName()) || "XDB".equals(example.getName())) {
                return true;
            }
        } else if (example instanceof Table) {
            if (example.getName().startsWith("BIN$")) {
                return true;
            }
            if (example.getName().startsWith("AQ$")) {
                return true;
            }
            if (example.getName().startsWith("DR$")) {
                return true;
            }
            if (example.getName().startsWith("SYS_IOT_OVER")) {
                return true;
            }
        }
        return super.isSystemObject(example);
    }

    public boolean supportsTablespaces() {
        return true;
    }

    public boolean supportsAutoIncrement() {
        return false;
    }

    public boolean supportsRestrictForeignKeys() {
        return false;
    }

    public int getDataTypeMaxParameters(String dataTypeName) {
        if (dataTypeName.toUpperCase().equals("BINARY_FLOAT")) {
            return 0;
        }
        if (dataTypeName.toUpperCase().equals("BINARY_DOUBLE")) {
            return 0;
        }
        return super.getDataTypeMaxParameters(dataTypeName);
    }

    public boolean jdbcCallsCatalogsSchemas() {
        return true;
    }
}

