/*
 * Decompiled with CFR 0.152.
 */
package liquibase.datatype.core;

import java.sql.Timestamp;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.core.FirebirdDatabase;
import liquibase.database.core.H2Database;
import liquibase.database.core.HsqlDatabase;
import liquibase.database.core.MaxDBDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.database.core.SQLiteDatabase;
import liquibase.datatype.DataTypeInfo;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.LiquibaseDataType;
import liquibase.statement.DatabaseFunction;

@DataTypeInfo(name="datetime", aliases={"java.sql.Types.DATETIME", "java.util.Date"}, minParameters=0, maxParameters=1, priority=1)
public class DateTimeType
extends LiquibaseDataType {
    public DatabaseDataType toDatabaseDataType(Database database) {
        if (database instanceof DB2Database || database instanceof DerbyDatabase || database instanceof FirebirdDatabase || database instanceof H2Database || database instanceof HsqlDatabase || database instanceof MaxDBDatabase || database instanceof OracleDatabase) {
            return new DatabaseDataType("TIMESTAMP");
        }
        if (database instanceof PostgresDatabase) {
            return new DatabaseDataType("TIMESTAMP WITH TIME ZONE");
        }
        if (database instanceof SQLiteDatabase) {
            return new DatabaseDataType("TEXT");
        }
        return new DatabaseDataType(this.getName());
    }

    public String objectToSql(Object value, Database database) {
        if (value == null || value.toString().equalsIgnoreCase("null")) {
            return null;
        }
        if (value instanceof DatabaseFunction) {
            return database.generateDatabaseFunctionValue((DatabaseFunction)value);
        }
        if (database.isFunction(value.toString())) {
            return value.toString();
        }
        if (value instanceof String) {
            return "'" + ((String)value).replaceAll("'", "''") + "'";
        }
        return database.getDateTimeLiteral((Timestamp)value);
    }

    public Object sqlToObject(String value, Database database) {
        if (database instanceof DB2Database) {
            return value.replaceFirst("^\"SYSIBM\".\"TIMESTAMP\"\\('", "").replaceFirst("'\\)", "");
        }
        if (database instanceof DerbyDatabase) {
            return value.replaceFirst("^TIMESTAMP\\('", "").replaceFirst("'\\)", "");
        }
        return super.sqlToObject(value, database);
    }
}

