/*
 * Decompiled with CFR 0.152.
 */
package liquibase.diff;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.StringDiff;
import liquibase.diff.compare.CompareControl;
import liquibase.exception.DatabaseException;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.structure.DatabaseObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffResult {
    private DatabaseSnapshot referenceSnapshot;
    private DatabaseSnapshot comparisonSnapshot;
    private CompareControl compareControl;
    private StringDiff productNameDiff;
    private StringDiff productVersionDiff;
    private Set<DatabaseObject> missingObjects = new HashSet<DatabaseObject>();
    private Set<DatabaseObject> unexpectedObjects = new HashSet<DatabaseObject>();
    private Map<DatabaseObject, ObjectDifferences> changedObjects = new HashMap<DatabaseObject, ObjectDifferences>();

    public DiffResult(DatabaseSnapshot referenceDatabaseSnapshot, DatabaseSnapshot comparisonDatabaseSnapshot, CompareControl compareControl) {
        this.referenceSnapshot = referenceDatabaseSnapshot;
        this.comparisonSnapshot = comparisonDatabaseSnapshot;
        this.compareControl = compareControl;
    }

    public DatabaseSnapshot getReferenceSnapshot() {
        return this.referenceSnapshot;
    }

    public DatabaseSnapshot getComparisonSnapshot() {
        return this.comparisonSnapshot;
    }

    public StringDiff getProductNameDiff() {
        return this.productNameDiff;
    }

    public void setProductNameDiff(StringDiff productNameDiff) {
        this.productNameDiff = productNameDiff;
    }

    public StringDiff getProductVersionDiff() {
        return this.productVersionDiff;
    }

    public void setProductVersionDiff(StringDiff productVersionDiff) {
        this.productVersionDiff = productVersionDiff;
    }

    public CompareControl getCompareControl() {
        return this.compareControl;
    }

    public Set<? extends DatabaseObject> getMissingObjects() {
        return this.missingObjects;
    }

    public <T extends DatabaseObject> Set<T> getMissingObjects(Class<T> type) {
        HashSet<DatabaseObject> returnSet = new HashSet<DatabaseObject>();
        for (DatabaseObject obj : this.missingObjects) {
            if (!type.isAssignableFrom(obj.getClass())) continue;
            returnSet.add(obj);
        }
        return returnSet;
    }

    public void addMissingObject(DatabaseObject obj) {
        this.missingObjects.add(obj);
    }

    public Set<? extends DatabaseObject> getUnexpectedObjects() {
        return this.unexpectedObjects;
    }

    public <T extends DatabaseObject> Set<T> getUnexpectedObjects(Class<T> type) {
        HashSet<DatabaseObject> returnSet = new HashSet<DatabaseObject>();
        for (DatabaseObject obj : this.unexpectedObjects) {
            if (!type.isAssignableFrom(obj.getClass())) continue;
            returnSet.add(obj);
        }
        return returnSet;
    }

    public void addUnexpectedObject(DatabaseObject obj) {
        this.unexpectedObjects.add(obj);
    }

    public Map<DatabaseObject, ObjectDifferences> getChangedObjects() {
        return this.changedObjects;
    }

    public Map<DatabaseObject, ObjectDifferences> getChangedObjects(Class<? extends DatabaseObject> type) {
        HashMap<DatabaseObject, ObjectDifferences> returnSet = new HashMap<DatabaseObject, ObjectDifferences>();
        for (Map.Entry<DatabaseObject, ObjectDifferences> obj : this.changedObjects.entrySet()) {
            if (!type.isAssignableFrom(obj.getKey().getClass())) continue;
            returnSet.put(obj.getKey(), obj.getValue());
        }
        return returnSet;
    }

    public void addChangedObject(DatabaseObject obj, ObjectDifferences differences) {
        this.changedObjects.put(obj, differences);
    }

    public boolean areEqual() throws DatabaseException, IOException {
        return this.missingObjects.size() == 0 && this.unexpectedObjects.size() == 0 && this.changedObjects.size() == 0;
    }

    public Set<Class<? extends DatabaseObject>> getComparedTypes() {
        return this.compareControl.getComparedTypes();
    }
}

