/*
 * Decompiled with CFR 0.152.
 */
package liquibase.diff;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import liquibase.database.Database;
import liquibase.diff.Difference;
import liquibase.structure.DatabaseObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectDifferences {
    private HashMap<String, Difference> differences = new HashMap();

    public Set<Difference> getDifferences() {
        return Collections.unmodifiableSet(new HashSet<Difference>(this.differences.values()));
    }

    public ObjectDifferences addDifference(String changedField, Object referenceValue, Object compareToValue) {
        this.differences.put(changedField, new Difference(changedField, referenceValue, compareToValue));
        return this;
    }

    public ObjectDifferences addDifference(String message, String changedField, Object referenceValue, Object compareToValue) {
        this.differences.put(changedField, new Difference(message, changedField, referenceValue, compareToValue));
        return this;
    }

    public boolean hasDifferences() {
        return this.differences.size() > 0;
    }

    public void compare(String attribute, DatabaseObject referenceObject, DatabaseObject compareToObject, CompareFunction compareFunction) {
        this.compare(null, attribute, referenceObject, compareToObject, compareFunction);
    }

    public void compare(String message, String attribute, DatabaseObject referenceObject, DatabaseObject compareToObject, CompareFunction compareFunction) {
        boolean different;
        Object referenceValue = referenceObject.getAttribute(attribute, Object.class);
        Object compareValue = compareToObject.getAttribute(attribute, Object.class);
        if (referenceValue == null && compareValue == null) {
            different = false;
        } else if (referenceValue == null || compareValue == null) {
            different = false;
        } else {
            boolean bl = different = !compareFunction.areEqual(referenceValue, compareValue);
        }
        if (different) {
            this.addDifference(message, attribute, referenceValue, compareValue);
        }
    }

    public boolean removeDifference(String attribute) {
        return this.differences.remove(attribute) != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DatabaseObjectNameCompareFunction
    implements CompareFunction {
        private final Database accordingTo;
        private Class<? extends DatabaseObject> type;

        public DatabaseObjectNameCompareFunction(Class<? extends DatabaseObject> type, Database accordingTo) {
            this.type = type;
            this.accordingTo = accordingTo;
        }

        @Override
        public boolean areEqual(Object referenceValue, Object compareToValue) {
            if (referenceValue instanceof Collection) {
                if (((Collection)referenceValue).size() != ((Collection)compareToValue).size()) {
                    return false;
                }
                Iterator referenceIterator = ((Collection)referenceValue).iterator();
                Iterator compareToIterator = ((Collection)compareToValue).iterator();
                while (referenceIterator.hasNext()) {
                    if (this.areEqual(referenceIterator.next(), compareToIterator.next())) continue;
                    return false;
                }
                return true;
            }
            if (referenceValue == null && compareToValue == null) {
                return true;
            }
            if (referenceValue == null || compareToValue == null) {
                return false;
            }
            String object1Name = referenceValue instanceof DatabaseObject ? this.accordingTo.correctObjectName(((DatabaseObject)referenceValue).getAttribute("name", String.class), this.type) : referenceValue.toString();
            String object2Name = compareToValue instanceof DatabaseObject ? this.accordingTo.correctObjectName(((DatabaseObject)compareToValue).getAttribute("name", String.class), this.type) : referenceValue.toString();
            if (object1Name == null && object2Name == null) {
                return true;
            }
            if (object1Name == null || object2Name == null) {
                return false;
            }
            if (this.accordingTo.isCaseSensitive()) {
                return object1Name.equals(object2Name);
            }
            return object1Name.equalsIgnoreCase(object2Name);
        }
    }

    public static class ToStringCompareFunction
    implements CompareFunction {
        public boolean areEqual(Object referenceValue, Object compareToValue) {
            if (referenceValue == null && compareToValue == null) {
                return true;
            }
            if (referenceValue == null || compareToValue == null) {
                return false;
            }
            return referenceValue.toString().equals(compareToValue.toString());
        }
    }

    public static class StandardCompareFunction
    implements CompareFunction {
        public boolean areEqual(Object referenceValue, Object compareToValue) {
            if (referenceValue == null && compareToValue == null) {
                return true;
            }
            if (referenceValue == null || compareToValue == null) {
                return false;
            }
            return referenceValue.equals(compareToValue);
        }
    }

    public static interface CompareFunction {
        public boolean areEqual(Object var1, Object var2);
    }
}

