/*
 * Decompiled with CFR 0.152.
 */
package liquibase.diff.compare;

import java.util.HashSet;
import java.util.Set;
import liquibase.CatalogAndSchema;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.logging.LogFactory;
import liquibase.servicelocator.ServiceLocator;
import liquibase.structure.DatabaseObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareControl {
    private static Set<Class<? extends DatabaseObject>> defaultTypes;
    private SchemaComparison[] schemaComparisons;
    private Set<Class<? extends DatabaseObject>> compareTypes = new HashSet<Class<? extends DatabaseObject>>();

    public CompareControl() {
        this(null);
    }

    public CompareControl(Set<Class<? extends DatabaseObject>> compareTypes) {
        this.schemaComparisons = new SchemaComparison[]{new SchemaComparison(new CatalogAndSchema(null, null), new CatalogAndSchema(null, null))};
        this.initCompareTypes(compareTypes);
    }

    public CompareControl(SchemaComparison[] schemaComparison, Set<Class<? extends DatabaseObject>> compareTypes) {
        this.schemaComparisons = schemaComparison;
        this.initCompareTypes(compareTypes);
    }

    public CompareControl(String[] referenceVsComparisonSchemas, Set<Class<? extends DatabaseObject>> compareTypes) {
        String[] splitReferenceSchemas = referenceVsComparisonSchemas[0].split(",");
        String[] splitComparisonSchemas = referenceVsComparisonSchemas[1].split(",");
        this.schemaComparisons = new SchemaComparison[splitReferenceSchemas.length];
        for (int i = 0; i < splitReferenceSchemas.length; ++i) {
            String referenceCatalogName = null;
            String referenceSchemaName = splitReferenceSchemas[i];
            if (referenceSchemaName.contains(".")) {
                referenceCatalogName = referenceSchemaName.split(".", 2)[0];
                referenceSchemaName = referenceSchemaName.split(".", 2)[1];
            }
            String comparisonCatalogName = null;
            String comparisonSchemaName = splitComparisonSchemas[i];
            if (comparisonSchemaName.contains(".")) {
                comparisonCatalogName = comparisonSchemaName.split(".", 2)[0];
                comparisonSchemaName = comparisonSchemaName.split(".", 2)[1];
            }
            CatalogAndSchema referenceSchema = new CatalogAndSchema(referenceCatalogName, referenceSchemaName);
            CatalogAndSchema comparisonSchema = new CatalogAndSchema(comparisonCatalogName, comparisonSchemaName);
            this.schemaComparisons[i] = new SchemaComparison(referenceSchema, comparisonSchema);
            this.initCompareTypes(compareTypes);
        }
    }

    private void initCompareTypes(Set<Class<? extends DatabaseObject>> compareTypes) {
        if (compareTypes == null || compareTypes.size() == 0) {
            compareTypes = this.getDefaultTypes();
        }
        this.compareTypes = compareTypes;
    }

    private Set<Class<? extends DatabaseObject>> getDefaultTypes() {
        if (defaultTypes == null) {
            Class<DatabaseObject>[] classes;
            HashSet<Class<? extends DatabaseObject>> set = new HashSet<Class<? extends DatabaseObject>>();
            for (Class<DatabaseObject> clazz : classes = ServiceLocator.getInstance().findClasses(DatabaseObject.class)) {
                try {
                    if (!clazz.newInstance().snapshotByDefault()) continue;
                    set.add(clazz);
                }
                catch (Exception e) {
                    LogFactory.getLogger().info("Cannot construct " + clazz.getName() + " to determine if it should be included in the snapshot by default");
                }
            }
            defaultTypes = set;
        }
        return defaultTypes;
    }

    public Set<Class<? extends DatabaseObject>> getComparedTypes() {
        return this.compareTypes;
    }

    public SchemaComparison[] getSchemaComparisons() {
        return this.schemaComparisons;
    }

    public CatalogAndSchema[] getSchemas(DatabaseRole databaseRole) {
        CatalogAndSchema[] schemas = new CatalogAndSchema[this.schemaComparisons.length];
        for (int i = 0; i < this.schemaComparisons.length; ++i) {
            if (databaseRole.equals((Object)DatabaseRole.COMPARISON)) {
                schemas[i] = this.schemaComparisons[i].getComparisonSchema();
                continue;
            }
            if (databaseRole.equals((Object)DatabaseRole.REFERENCE)) {
                schemas[i] = this.schemaComparisons[i].getReferenceSchema();
                continue;
            }
            throw new UnexpectedLiquibaseException("Unknkown diff type: " + (Object)((Object)databaseRole));
        }
        return schemas;
    }

    public static class SchemaComparison {
        private CatalogAndSchema comparisonSchema;
        private CatalogAndSchema referenceSchema;

        public SchemaComparison(CatalogAndSchema reference, CatalogAndSchema comparison) {
            this.referenceSchema = reference;
            this.comparisonSchema = comparison;
        }

        public CatalogAndSchema getComparisonSchema() {
            return this.comparisonSchema;
        }

        public CatalogAndSchema getReferenceSchema() {
            return this.referenceSchema;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DatabaseRole {
        REFERENCE,
        COMPARISON;

    }
}

