/*
 * Decompiled with CFR 0.152.
 */
package liquibase.diff.compare.core;

import liquibase.database.Database;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.compare.DatabaseObjectComparator;
import liquibase.diff.compare.DatabaseObjectComparatorChain;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaComparator
implements DatabaseObjectComparator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (Schema.class.isAssignableFrom(objectType)) {
            return 5;
        }
        return -1;
    }

    @Override
    public boolean isSameObject(DatabaseObject databaseObject1, DatabaseObject databaseObject2, Database accordingTo, DatabaseObjectComparatorChain chain) {
        if (chain.isSameObject(databaseObject1, databaseObject2, accordingTo)) {
            return true;
        }
        if (!(databaseObject1 instanceof Schema) || !(databaseObject2 instanceof Schema)) {
            return false;
        }
        Schema thisSchema = (Schema)databaseObject1;
        Schema otherSchema = (Schema)databaseObject2;
        if (accordingTo.supportsCatalogs()) {
            if (thisSchema.getCatalogName() == null) {
                return otherSchema.getCatalogName() == null || accordingTo.getDefaultCatalogName() == null || accordingTo.getDefaultCatalogName().equals(otherSchema.getCatalogName());
            }
            if (!thisSchema.getCatalogName().equals(otherSchema.getCatalogName())) {
                return false;
            }
        }
        if (accordingTo.supportsSchemas()) {
            return thisSchema.getName().equals(otherSchema.getName());
        }
        return true;
    }

    @Override
    public ObjectDifferences findDifferences(DatabaseObject databaseObject1, DatabaseObject databaseObject2, Database accordingTo, DatabaseObjectComparatorChain chain) {
        return chain.findDifferences(databaseObject1, databaseObject2, accordingTo);
    }
}

