/*
 * Decompiled with CFR 0.152.
 */
package liquibase.exception;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationErrors {
    protected List<String> errorMessages = new ArrayList<String>();

    public boolean hasErrors() {
        return this.errorMessages.size() > 0;
    }

    public void checkRequiredField(String requiredFieldName, Object value) {
        if (value == null) {
            this.addError(requiredFieldName + " is required");
        } else if (value instanceof Collection && ((Collection)value).size() == 0) {
            this.addError(requiredFieldName + " is empty");
        } else if (value instanceof Object[] && ((Object[])value).length == 0) {
            this.addError(requiredFieldName + " is empty");
        }
    }

    public void checkDisallowedField(String disallowedFieldName, Object value, Database database, Class<? extends Database> ... disallowedDatabases) {
        boolean isDisallowed = false;
        if (disallowedDatabases == null || disallowedDatabases.length == 0) {
            isDisallowed = true;
        } else {
            for (Class<? extends Database> databaseClass : disallowedDatabases) {
                if (!databaseClass.isAssignableFrom(database.getClass())) continue;
                isDisallowed = true;
            }
        }
        if (isDisallowed && value != null) {
            this.addError(disallowedFieldName + " is not allowed on " + database.getShortName());
        }
    }

    public ValidationErrors addError(String message) {
        this.errorMessages.add(message);
        return this;
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public ValidationErrors addAll(ValidationErrors validationErrors) {
        if (validationErrors == null) {
            return this;
        }
        this.errorMessages.addAll(validationErrors.getErrorMessages());
        return this;
    }

    public void addAll(ValidationErrors validationErrors, ChangeSet changeSet) {
        for (String message : validationErrors.getErrorMessages()) {
            this.errorMessages.add(message + ", " + changeSet);
        }
    }

    public String toString() {
        if (this.getErrorMessages().size() == 0) {
            return "No errors";
        }
        return StringUtils.join(this.getErrorMessages(), "; ");
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public List<String> getRequiredErrorMessages() {
        ArrayList<String> requiredErrorMessages = new ArrayList<String>();
        for (String message : this.errorMessages) {
            if (!message.contains("is required")) continue;
            requiredErrorMessages.add(message);
        }
        return Collections.unmodifiableList(requiredErrorMessages);
    }

    public List<String> getUnsupportedErrorMessages() {
        ArrayList<String> unsupportedErrorMessages = new ArrayList<String>();
        for (String message : this.errorMessages) {
            if (!message.contains(" is not allowed on ")) continue;
            unsupportedErrorMessages.add(message);
        }
        return Collections.unmodifiableList(unsupportedErrorMessages);
    }
}

