/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.ant;

import java.io.PrintStream;
import liquibase.CatalogAndSchema;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.diff.DiffResult;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.DiffToChangeLog;
import liquibase.exception.DatabaseException;
import liquibase.integration.ant.BaseLiquibaseTask;
import liquibase.logging.LogFactory;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.util.StringUtils;
import org.apache.tools.ant.BuildException;

public class DiffDatabaseTask
extends BaseLiquibaseTask {
    private String referenceDriver;
    private String referenceUrl;
    private String referenceUsername;
    private String referencePassword;
    private String referenceDefaultCatalogName;
    private String referenceDefaultSchemaName;
    private String diffTypes;
    private String dataDir;
    private boolean includeCatalog;
    private boolean includeSchema;
    private boolean includeTablespace;

    public String getDiffTypes() {
        return this.diffTypes;
    }

    public void setDiffTypes(String diffTypes) {
        this.diffTypes = diffTypes;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public void setDataDir(String dataDir) {
        this.dataDir = dataDir;
    }

    public String getReferenceDriver() {
        return this.referenceDriver;
    }

    public void setReferenceDriver(String referenceDriver) {
        this.referenceDriver = referenceDriver;
    }

    public String getReferenceUrl() {
        return this.referenceUrl;
    }

    public void setReferenceUrl(String referenceUrl) {
        this.referenceUrl = referenceUrl;
    }

    public String getReferenceUsername() {
        return this.referenceUsername;
    }

    public void setReferenceUsername(String referenceUsername) {
        this.referenceUsername = referenceUsername;
    }

    public String getReferencePassword() {
        return this.referencePassword;
    }

    public void setReferencePassword(String referencePassword) {
        this.referencePassword = referencePassword;
    }

    public String getReferenceDefaultCatalogName() {
        return this.referenceDefaultCatalogName;
    }

    public void setReferenceDefaultCatalogName(String referenceDefaultCatalogName) {
        this.referenceDefaultCatalogName = referenceDefaultCatalogName;
    }

    public String getReferenceDefaultSchemaName() {
        return this.referenceDefaultSchemaName;
    }

    public void setReferenceDefaultSchemaName(String referenceDefaultSchemaName) {
        this.referenceDefaultSchemaName = referenceDefaultSchemaName;
    }

    public boolean getIncludeCatalog() {
        return this.includeCatalog;
    }

    public void setIncludeCatalog(boolean includeCatalog) {
        this.includeCatalog = includeCatalog;
    }

    public boolean getIncludeSchema() {
        return this.includeSchema;
    }

    public void setIncludeSchema(boolean includeSchema) {
        this.includeSchema = includeSchema;
    }

    public boolean getIncludeTablespace() {
        return this.includeTablespace;
    }

    public void setIncludeTablespace(boolean includeTablespace) {
        this.includeTablespace = includeTablespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeWithLiquibaseClassloader() throws BuildException {
        if (StringUtils.trimToNull(this.getReferenceUrl()) == null) {
            throw new BuildException("diffDatabase requires referenceUrl to be set");
        }
        Liquibase liquibase = null;
        Database referenceDatabase = null;
        try {
            PrintStream writer = this.createPrintStream();
            if (writer == null && this.getChangeLogFile() == null) {
                throw new BuildException("diffDatabase requires outputFile or changeLogFile to be set");
            }
            liquibase = this.createLiquibase();
            referenceDatabase = this.createDatabaseObject(this.getReferenceDriver(), this.getReferenceUrl(), this.getReferenceUsername(), this.getReferencePassword(), this.getReferenceDefaultCatalogName(), this.getReferenceDefaultSchemaName(), this.getDatabaseClass());
            DiffOutputControl diffOutputControl = new DiffOutputControl();
            diffOutputControl.setDataDir(this.getDataDir());
            DatabaseSnapshot referenceSnapshot = SnapshotGeneratorFactory.getInstance().createSnapshot(referenceDatabase.getDefaultSchema(), referenceDatabase, new SnapshotControl(this.getDiffTypes()));
            DatabaseSnapshot comparisonSnapshot = SnapshotGeneratorFactory.getInstance().createSnapshot(liquibase.getDatabase().getDefaultSchema(), liquibase.getDatabase(), new SnapshotControl(this.getDiffTypes()));
            CompareControl compareControl = new CompareControl(new CompareControl.SchemaComparison[]{new CompareControl.SchemaComparison(new CatalogAndSchema(this.getReferenceDefaultCatalogName(), this.getReferenceDefaultSchemaName()), new CatalogAndSchema(this.getDefaultCatalogName(), this.getDefaultSchemaName()))}, referenceSnapshot.getSnapshotControl().getTypesToInclude());
            DiffResult diffResult = liquibase.diff(referenceDatabase, liquibase.getDatabase(), compareControl);
            this.outputDiff(writer, diffResult, liquibase.getDatabase());
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
        catch (Exception e) {
            try {
                throw new BuildException((Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    this.closeDatabase(liquibase);
                    throw throwable;
                }
                finally {
                    if (referenceDatabase != null && referenceDatabase.getConnection() != null) {
                        try {
                            referenceDatabase.close();
                        }
                        catch (DatabaseException e2) {
                            LogFactory.getLogger().severe("Error closing referenceDatabase", e2);
                        }
                    }
                }
            }
        }
        try {
            this.closeDatabase(liquibase);
            return;
        }
        finally {
            if (referenceDatabase != null && referenceDatabase.getConnection() != null) {
                try {
                    referenceDatabase.close();
                }
                catch (DatabaseException e) {
                    LogFactory.getLogger().severe("Error closing referenceDatabase", e);
                }
            }
        }
    }

    protected void outputDiff(PrintStream writer, DiffResult diffResult, Database targetDatabase) throws Exception {
        new DiffToChangeLog(diffResult, new DiffOutputControl(this.getIncludeCatalog(), this.getIncludeSchema(), this.getIncludeTablespace())).print(writer);
    }
}

