/*
 * Decompiled with CFR 0.152.
 */
package liquibase.serializer.core.json;

import liquibase.serializer.LiquibaseSerializable;
import liquibase.serializer.core.yaml.YamlChangeLogSerializer;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public class JsonChangeLogSerializer
extends YamlChangeLogSerializer {
    protected Yaml createYaml() {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setPrettyFlow(true);
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.FLOW);
        dumperOptions.setDefaultScalarStyle(DumperOptions.ScalarStyle.DOUBLE_QUOTED);
        return new Yaml((Representer)new YamlChangeLogSerializer.LiquibaseRepresenter(), dumperOptions);
    }

    public String serialize(LiquibaseSerializable object, boolean pretty) {
        String out = this.yaml.dumpAs(this.toMap(object), Tag.MAP, DumperOptions.FlowStyle.FLOW);
        out = out.replaceAll("!!int \"(\\d+)\"", "$1");
        out = out.replaceAll("!!bool \"(\\w+)\"", "$1");
        out = out.replaceAll("!!timestamp \"([^\"]*)\"", "$1");
        return out;
    }

    public String[] getValidFileExtensions() {
        return new String[]{"json"};
    }
}

