/*
 * Decompiled with CFR 0.152.
 */
package liquibase.snapshot;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.jvm.ColumnMapRowMapper;
import liquibase.executor.jvm.RowMapperResultSetExtractor;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.SnapshotControl;

public class JdbcDatabaseSnapshot
extends DatabaseSnapshot {
    private CachingDatabaseMetaData cachingDatabaseMetaData;
    private int tablesOfColumnsFetched = 0;

    public JdbcDatabaseSnapshot(SnapshotControl snapshotControl, Database database) {
        super(snapshotControl, database);
    }

    public JdbcDatabaseSnapshot(Database database) {
        super(database);
    }

    public CachingDatabaseMetaData getMetaData() throws SQLException {
        if (this.cachingDatabaseMetaData == null) {
            DatabaseMetaData databaseMetaData = null;
            if (this.getDatabase().getConnection() != null) {
                databaseMetaData = ((JdbcConnection)this.getDatabase().getConnection()).getUnderlyingConnection().getMetaData();
            }
            this.cachingDatabaseMetaData = new CachingDatabaseMetaData(databaseMetaData);
        }
        return this.cachingDatabaseMetaData;
    }

    protected boolean shouldCacheAllTableColumns() {
        return this.tablesOfColumnsFetched == 4;
    }

    public class CachedRow {
        private Map row;

        public CachedRow(Map row) {
            this.row = row;
        }

        public Object get(String columnName) {
            return this.row.get(columnName);
        }

        public void set(String columnName, Object value) {
            this.row.put(columnName, value);
        }

        public boolean containsColumn(String columnName) {
            return this.row.containsKey(columnName);
        }

        public String getString(String columnName) {
            return (String)this.row.get(columnName);
        }

        public Integer getInt(String columnName) {
            Object o = this.row.get(columnName);
            if (o instanceof Number) {
                return ((Number)o).intValue();
            }
            if (o instanceof String) {
                return Integer.valueOf((String)o);
            }
            return (Integer)o;
        }

        public Short getShort(String columnName) {
            Object o = this.row.get(columnName);
            if (o instanceof Number) {
                return ((Number)o).shortValue();
            }
            if (o instanceof String) {
                return Short.valueOf((String)o);
            }
            return (Short)o;
        }

        public Boolean getBoolean(String columnName) {
            Object o = this.row.get(columnName);
            if (o instanceof Number) {
                if (((Number)o).longValue() == 0L) {
                    return false;
                }
                return true;
            }
            if (o instanceof String) {
                return Boolean.valueOf((String)o);
            }
            return (Boolean)o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CachingDatabaseMetaData {
        private DatabaseMetaData databaseMetaData;
        private Map<String, List<CachedRow>> cachedResults = new HashMap<String, List<CachedRow>>();

        public CachingDatabaseMetaData(DatabaseMetaData metaData) {
            this.databaseMetaData = metaData;
        }

        public DatabaseMetaData getDatabaseMetaData() {
            return this.databaseMetaData;
        }

        public List<CachedRow> getExportedKeys(String catalogName, String schemaName, String table) throws SQLException {
            String key = this.createKey("getExportedKeys", catalogName, schemaName, table);
            if (this.hasCachedValue(key)) {
                return this.getCachedValue(key);
            }
            return this.cacheResultSet(key, this.databaseMetaData.getExportedKeys(catalogName, schemaName, table));
        }

        private List<CachedRow> getCachedValue(String key) {
            return this.cachedResults.get(key);
        }

        private boolean hasCachedValue(String key) {
            return this.cachedResults.containsKey(key);
        }

        private String createKey(String methodName, Object ... params) {
            String key = methodName;
            if (params != null) {
                for (Object param : params) {
                    key = key + ":" + param;
                }
            }
            return key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<CachedRow> cacheResultSet(String key, ResultSet rs) throws SQLException {
            List list;
            try {
                list = (List)new RowMapperResultSetExtractor(new ColumnMapRowMapper()).extractData(rs);
                for (int i = 0; i < list.size(); ++i) {
                    list.set(i, new CachedRow((Map)list.get(i)));
                }
            }
            finally {
                rs.close();
            }
            this.cachedResults.put(key, list);
            return list;
        }

        public List<CachedRow> getImportedKeys(String catalogName, String schemaName, String table) throws SQLException {
            String key = this.createKey("getImportedKeys", catalogName, schemaName, table);
            if (this.hasCachedValue(key)) {
                return this.getCachedValue(key);
            }
            return this.cacheResultSet(key, this.databaseMetaData.getImportedKeys(catalogName, schemaName, table));
        }

        public List<CachedRow> getIndexInfo(String catalogName, String schemaName, String table, boolean unique, boolean approximate) throws SQLException {
            String key = this.createKey("getIndexInfo", catalogName, schemaName, table, unique, approximate);
            if (this.hasCachedValue(key)) {
                return this.getCachedValue(key);
            }
            return this.cacheResultSet(key, this.databaseMetaData.getIndexInfo(catalogName, schemaName, table, unique, approximate));
        }

        public List<CachedRow> getColumns(String catalogName, String schemaName, String tableNamePattern, String columnNamePattern) throws SQLException {
            List<CachedRow> returnList;
            String byTableKey = this.createKey("getColumns", catalogName, schemaName, tableNamePattern);
            String allTablesKey = this.createKey("getColumns", catalogName, schemaName);
            boolean needToFilter = false;
            if (this.hasCachedValue(byTableKey)) {
                returnList = this.getCachedValue(byTableKey);
            } else if (this.hasCachedValue(allTablesKey)) {
                returnList = this.getCachedValue(allTablesKey);
                needToFilter = true;
            } else {
                JdbcDatabaseSnapshot.this.tablesOfColumnsFetched++;
                if (JdbcDatabaseSnapshot.this.shouldCacheAllTableColumns()) {
                    returnList = this.cacheResultSet(allTablesKey, this.databaseMetaData.getColumns(catalogName, schemaName, null, null));
                    needToFilter = true;
                } else {
                    returnList = this.cacheResultSet(byTableKey, this.databaseMetaData.getColumns(catalogName, schemaName, tableNamePattern, null));
                    if (returnList.size() == 0) {
                        throw new UnexpectedLiquibaseException("No Columns found for table " + tableNamePattern);
                    }
                }
            }
            if (columnNamePattern != null || needToFilter) {
                ArrayList<CachedRow> filteredList = new ArrayList<CachedRow>();
                for (CachedRow row : returnList) {
                    if (JdbcDatabaseSnapshot.this.getDatabase().isCaseSensitive()) {
                        if (!row.getString("TABLE_NAME").equals(tableNamePattern) || columnNamePattern != null && !row.getString("COLUMN_NAME").equals(columnNamePattern)) continue;
                        filteredList.add(row);
                        continue;
                    }
                    if (!row.getString("TABLE_NAME").equalsIgnoreCase(tableNamePattern) || columnNamePattern != null && !row.getString("COLUMN_NAME").equalsIgnoreCase(columnNamePattern)) continue;
                    filteredList.add(row);
                }
                if (filteredList.size() == 0) {
                    System.out.println("zero size");
                }
                return filteredList;
            }
            if (returnList.size() == 0) {
                System.out.println("zero size");
            }
            return returnList;
        }

        public List<CachedRow> getTables(String catalogName, String schemaName, String tableNamePattern, String[] types) throws SQLException {
            String key = this.createKey("getTables", catalogName, schemaName, tableNamePattern, types);
            if (this.hasCachedValue(key)) {
                return this.getCachedValue(key);
            }
            return this.cacheResultSet(key, this.databaseMetaData.getTables(catalogName, schemaName, tableNamePattern, types));
        }

        public List<CachedRow> getPrimaryKeys(String catalogName, String schemaName, String table) throws SQLException {
            String key = this.createKey("getPrimaryKeys", catalogName, schemaName, table);
            if (this.hasCachedValue(key)) {
                return this.getCachedValue(key);
            }
            return this.cacheResultSet(key, this.databaseMetaData.getPrimaryKeys(catalogName, schemaName, table));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<CachedRow> query(String sql) throws SQLException {
            String key = this.createKey("query", sql);
            if (this.hasCachedValue(key)) {
                return this.getCachedValue(key);
            }
            Statement statement = this.getDatabaseMetaData().getConnection().createStatement();
            try {
                List<CachedRow> list = this.cacheResultSet(key, statement.executeQuery(sql));
                return list;
            }
            finally {
                statement.close();
            }
        }
    }
}

