/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import liquibase.database.Database;
import liquibase.database.core.CacheDatabase;
import liquibase.database.core.DB2Database;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.core.H2Database;
import liquibase.database.core.HsqlDatabase;
import liquibase.database.core.InformixDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MaxDBDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.SybaseASADatabase;
import liquibase.database.core.SybaseDatabase;
import liquibase.datatype.DataTypeFactory;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.core.ModifyDataTypeStatement;
import liquibase.structure.core.Relation;
import liquibase.structure.core.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyDataTypeGenerator
extends AbstractSqlGenerator<ModifyDataTypeStatement> {
    @Override
    public Warnings warn(ModifyDataTypeStatement modifyDataTypeStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        Warnings warnings = super.warn(modifyDataTypeStatement, database, sqlGeneratorChain);
        if (database instanceof MySQLDatabase && !modifyDataTypeStatement.getNewDataType().toLowerCase().contains("varchar")) {
            warnings.addWarning("modifyDataType will lose primary key/autoincrement/not null settings for mysql.  Use <sql> and re-specify all configuration if this is the case");
        }
        return warnings;
    }

    @Override
    public ValidationErrors validate(ModifyDataTypeStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("tableName", statement.getTableName());
        validationErrors.checkRequiredField("columnName", statement.getColumnName());
        validationErrors.checkRequiredField("newDataType", statement.getNewDataType());
        return validationErrors;
    }

    @Override
    public Sql[] generateSql(ModifyDataTypeStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String alterTable = "ALTER TABLE " + database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName());
        alterTable = alterTable + " " + this.getModifyString(database) + " ";
        alterTable = alterTable + database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), statement.getColumnName());
        alterTable = alterTable + this.getPreDataTypeString(database);
        alterTable = alterTable + DataTypeFactory.getInstance().fromDescription(statement.getNewDataType()).toDatabaseDataType(database);
        return new Sql[]{new UnparsedSql(alterTable, this.getAffectedTable(statement))};
    }

    protected Relation getAffectedTable(ModifyDataTypeStatement statement) {
        return new Table().setName(statement.getTableName()).setSchema(statement.getCatalogName(), statement.getSchemaName());
    }

    private String getModifyString(Database database) {
        if (database instanceof SybaseASADatabase || database instanceof SybaseDatabase || database instanceof MySQLDatabase || database instanceof OracleDatabase || database instanceof MaxDBDatabase || database instanceof InformixDatabase) {
            return "MODIFY";
        }
        return "ALTER COLUMN";
    }

    private String getPreDataTypeString(Database database) {
        if (database instanceof DerbyDatabase || database instanceof DB2Database) {
            return " SET DATA TYPE ";
        }
        if (database instanceof SybaseASADatabase || database instanceof SybaseDatabase || database instanceof MSSQLDatabase || database instanceof MySQLDatabase || database instanceof HsqlDatabase || database instanceof H2Database || database instanceof CacheDatabase || database instanceof OracleDatabase || database instanceof MaxDBDatabase || database instanceof InformixDatabase) {
            return " ";
        }
        return " TYPE ";
    }
}

