/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import liquibase.CatalogAndSchema;
import liquibase.changelog.column.LiquibaseColumn;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.DatabaseConnection;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.executor.ExecutorService;
import liquibase.logging.LogService;
import liquibase.logging.LogType;
import liquibase.logging.Logger;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawCallStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Table;
import liquibase.util.JdbcUtils;
import liquibase.util.StringUtils;

public class PostgresDatabase
extends AbstractJdbcDatabase {
    private String dbFullVersion = null;
    public static final String PRODUCT_NAME = "PostgreSQL";
    public static final int MINIMUM_DBMS_MAJOR_VERSION = 9;
    public static final int MINIMUM_DBMS_MINOR_VERSION = 2;
    private static final int PGSQL_DEFAULT_TCP_PORT_NUMBER = 5432;
    private static final Logger LOG = LogService.getLog(PostgresDatabase.class);
    private Set<String> systemTablesAndViews = new HashSet<String>();
    private Set<String> reservedWords = new HashSet<String>();
    private Logger log;

    public PostgresDatabase() {
        super.setCurrentDateTimeFunction("NOW()");
        this.reservedWords.addAll(Arrays.asList("ALL", "ANALYSE", "ANALYZE", "AND", "ANY", "ARRAY", "AS", "ASC", "ASYMMETRIC", "AUTHORIZATION", "BINARY", "BOTH", "CASE", "CAST", "CHECK", "COLLATE", "COLLATION", "COLUMN", "CONCURRENTLY", "CONSTRAINT", "CREATE", "CROSS", "CURRENT_CATALOG", "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_SCHEMA", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "DEFAULT", "DEFERRABLE", "DESC", "DISTINCT", "DO", "ELSE", "END", "EXCEPT", "FALSE", "FETCH", "FOR", "FOREIGN", "FREEZE", "FROM", "FULL", "GRANT", "GROUP", "HAVING", "ILIKE", "IN", "INITIALLY", "INNER", "INTERSECT", "INTO", "IS", "ISNULL", "JOIN", "LATERAL", "LEADING", "LEFT", "LIKE", "LIMIT", "LOCALTIME", "LOCALTIMESTAMP", "NATURAL", "NOT", "NOTNULL", "NULL", "OFFSET", "ON", "ONLY", "OR", "ORDER", "OUTER", "OVERLAPS", "PLACING", "PRIMARY", "REFERENCES", "RETURNING", "RIGHT", "SELECT", "SESSION_USER", "SIMILAR", "SOME", "SYMMETRIC", "TABLE", "TABLESAMPLE", "THEN", "TO", "TRAILING", "TRUE", "UNION", "UNIQUE", "USER", "USING", "VARIADIC", "VERBOSE", "WHEN", "WHERE", "WINDOW", "WITH"));
        this.sequenceNextValueFunction = "nextval('%s')";
        this.sequenceCurrentValueFunction = "currval('%s')";
        this.unmodifiableDataTypes.addAll(Arrays.asList("bool", "int4", "int8", "float4", "float8", "bigserial", "serial", "oid", "bytea", "date", "timestamptz", "text"));
        this.unquotedObjectsAreUppercased = false;
        this.log = LogService.getLog(this.getClass());
    }

    @Override
    public boolean equals(Object o2) {
        return super.equals(o2);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String getShortName() {
        return "postgresql";
    }

    @Override
    protected String getDefaultDatabaseProductName() {
        return PRODUCT_NAME;
    }

    @Override
    public Integer getDefaultPort() {
        return 5432;
    }

    @Override
    public Set<String> getSystemViews() {
        return this.systemTablesAndViews;
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public boolean supportsInitiallyDeferrableColumns() {
        return true;
    }

    @Override
    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        if (!PRODUCT_NAME.equalsIgnoreCase(conn.getDatabaseProductName())) {
            return false;
        }
        int majorVersion = conn.getDatabaseMajorVersion();
        int minorVersion = conn.getDatabaseMinorVersion();
        if (majorVersion < 9 || majorVersion == 9 && minorVersion < 2) {
            LOG.warning(String.format("Your PostgreSQL software version (%d.%d) seems to indicate that your software is older than %d.%d. This means that you might encounter strange behaviour and incorrect error messages.", majorVersion, minorVersion, majorVersion, minorVersion));
            return true;
        }
        return true;
    }

    @Override
    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:postgresql:")) {
            return "org.postgresql.Driver";
        }
        return null;
    }

    @Override
    public boolean supportsCatalogInObjectName(Class<? extends DatabaseObject> type) {
        return false;
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public String getDatabaseChangeLogTableName() {
        return super.getDatabaseChangeLogTableName().toLowerCase(Locale.US);
    }

    @Override
    public String getDatabaseChangeLogLockTableName() {
        return super.getDatabaseChangeLogLockTableName().toLowerCase(Locale.US);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConnection(DatabaseConnection conn) {
        super.setConnection(conn);
        if (conn instanceof JdbcConnection) {
            ResultSet resultSet;
            Statement statement;
            block5: {
                statement = null;
                resultSet = null;
                try {
                    String setting;
                    statement = ((JdbcConnection)conn).createStatement();
                    resultSet = statement.executeQuery("select setting from pg_settings where name = 'edb_redwood_date'");
                    if (!resultSet.next() || (setting = resultSet.getString(1)) == null || !"on".equals(setting)) break block5;
                    LOG.warning(LogType.LOG, "EnterpriseDB " + conn.getURL() + " does not store DATE columns. Instead, it auto-converts them to TIMESTAMPs. (edb_redwood_date=true)");
                }
                catch (SQLException | DatabaseException e2) {
                    try {
                        LOG.info(LogType.LOG, "Cannot check pg_settings", e2);
                    }
                    catch (Throwable throwable) {
                        JdbcUtils.close(resultSet, statement);
                        throw throwable;
                    }
                    JdbcUtils.close(resultSet, statement);
                }
            }
            JdbcUtils.close(resultSet, statement);
        }
    }

    @Override
    public String unescapeDataTypeName(String dataTypeName) {
        return dataTypeName.replace("\"", "");
    }

    @Override
    public boolean isSystemObject(DatabaseObject example) {
        if (example instanceof Table && example.getSchema() != null && ("pg_catalog".equals(example.getSchema().getName()) || "pg_toast".equals(example.getSchema().getName()))) {
            return true;
        }
        return super.isSystemObject(example);
    }

    @Override
    public boolean supportsTablespaces() {
        return true;
    }

    @Override
    public String getAutoIncrementClause() {
        try {
            if (this.getDatabaseMajorVersion() < 10) {
                return "";
            }
        }
        catch (DatabaseException e2) {
            return "";
        }
        return super.getAutoIncrementClause();
    }

    @Override
    public boolean generateAutoIncrementStartWith(BigInteger startWith) {
        try {
            if (this.getDatabaseMajorVersion() < 10) {
                return false;
            }
        }
        catch (DatabaseException e2) {
            return false;
        }
        return super.generateAutoIncrementStartWith(startWith);
    }

    @Override
    public boolean generateAutoIncrementBy(BigInteger incrementBy) {
        try {
            if (this.getDatabaseMajorVersion() < 10) {
                return false;
            }
        }
        catch (DatabaseException e2) {
            return false;
        }
        return super.generateAutoIncrementBy(incrementBy);
    }

    @Override
    public String escapeObjectName(String objectName, Class<? extends DatabaseObject> objectType) {
        if (this.quotingStrategy == ObjectQuotingStrategy.LEGACY && this.hasMixedCase(objectName)) {
            return "\"" + objectName + "\"";
        }
        if (objectType != null && LiquibaseColumn.class.isAssignableFrom(objectType)) {
            return objectName != null && !objectName.isEmpty() ? objectName.trim() : objectName;
        }
        return super.escapeObjectName(objectName, objectType);
    }

    @Override
    public String correctObjectName(String objectName, Class<? extends DatabaseObject> objectType) {
        if (objectName == null || this.quotingStrategy != ObjectQuotingStrategy.LEGACY) {
            return super.correctObjectName(objectName, objectType);
        }
        if (objectName.contains("-") || this.hasMixedCase(objectName) || this.startsWithNumeric(objectName) || this.isReservedWord(objectName)) {
            return objectName;
        }
        return objectName.toLowerCase(Locale.US);
    }

    protected boolean hasMixedCase(String tableName) {
        if (tableName == null) {
            return false;
        }
        return StringUtils.hasUpperCase(tableName) && StringUtils.hasLowerCase(tableName);
    }

    @Override
    public boolean isReservedWord(String tableName) {
        return this.reservedWords.contains(tableName.toUpperCase());
    }

    @Override
    protected SqlStatement getConnectionSchemaNameCallStatement() {
        return new RawCallStatement("select current_schema()");
    }

    @Override
    public String generatePrimaryKeyName(String tableName) {
        return tableName.toUpperCase(Locale.US) + "_PKEY";
    }

    @Override
    public int getMaxFractionalDigitsForTimestamp() {
        int major = 0;
        int minor = 0;
        try {
            major = this.getDatabaseMajorVersion();
            minor = this.getDatabaseMinorVersion();
        }
        catch (DatabaseException x2) {
            LogService.getLog(this.getClass()).warning(LogType.LOG, "Unable to determine exact database server version - specified TIMESTAMP precision will not be set: ", x2);
            return 0;
        }
        String minimumVersion = "7.2";
        if (StringUtils.isMinimumVersion(minimumVersion, major, minor, 0)) {
            return 6;
        }
        return 0;
    }

    @Override
    public CatalogAndSchema.CatalogAndSchemaCase getSchemaAndCatalogCase() {
        return CatalogAndSchema.CatalogAndSchemaCase.LOWER_CASE;
    }

    public String getDatabaseFullVersion() throws DatabaseException {
        if (this.getConnection() == null) {
            throw new DatabaseException("Connection not set. Can not get database version. Postgres Database wasn't initialized in proper way !");
        }
        if (this.dbFullVersion != null) {
            return this.dbFullVersion;
        }
        String sqlToGetVersion = "SELECT version()";
        List result = ExecutorService.getInstance().getExecutor("jdbc", this).queryForList((SqlStatement)new RawSqlStatement("SELECT version()"), String.class);
        if (result != null && !result.isEmpty()) {
            this.dbFullVersion = result.get(0).toString();
            return this.dbFullVersion;
        }
        throw new DatabaseException("Connection set to Postgres type we don't support !");
    }

    public DbTypes getDbType() {
        boolean enterpriseDb = false;
        try {
            enterpriseDb = this.getDatabaseFullVersion().toLowerCase().contains("enterprisedb");
        }
        catch (DatabaseException e2) {
            this.log.severe("Can't get full version of Postgres DB. Used EDB as default", e2);
            return DbTypes.EDB;
        }
        return enterpriseDb ? DbTypes.EDB : DbTypes.COMMUNITY;
    }

    public static enum DbTypes {
        EDB,
        COMMUNITY,
        RDS,
        AURORA;

    }
}

