/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import liquibase.CatalogAndSchema;
import liquibase.change.AbstractChange;
import liquibase.change.ChangeStatus;
import liquibase.change.ChangeWithColumns;
import liquibase.change.CheckSum;
import liquibase.change.ColumnConfig;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.core.LoadDataColumnConfig;
import liquibase.changelog.ChangeSet;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.datatype.DataTypeFactory;
import liquibase.datatype.LiquibaseDataType;
import liquibase.exception.DatabaseException;
import liquibase.exception.DateParseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.Warnings;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.io.EmptyLineAndCommentSkippingInputStream;
import liquibase.logging.LogService;
import liquibase.logging.LogType;
import liquibase.logging.Logger;
import liquibase.resource.ResourceAccessor;
import liquibase.resource.UtfBomAwareReader;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.statement.BatchDmlExecutablePreparedStatement;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.ExecutablePreparedStatementBase;
import liquibase.statement.InsertExecutablePreparedStatement;
import liquibase.statement.SequenceNextValueFunction;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.InsertOrUpdateStatement;
import liquibase.statement.core.InsertSetStatement;
import liquibase.statement.core.InsertStatement;
import liquibase.structure.core.Column;
import liquibase.structure.core.DataType;
import liquibase.structure.core.Table;
import liquibase.util.BooleanParser;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtils;
import liquibase.util.csv.CSVReader;

@DatabaseChange(name="loadData", description="Loads data from a CSV file into an existing table. A value of NULL in a cell will be converted to a database NULL rather than the string 'NULL'.\nLines starting with # (hash) sign are treated as comments. You can change comment pattern by specifying 'commentLineStartsWith' property in loadData tag.To disable comments set 'commentLineStartsWith' to empty value'\n\nIf the data type for a load column is set to NUMERIC, numbers are parsed in US locale (e.g. 123.45).\nDate/Time values included in the CSV file should be in ISO format http://en.wikipedia.org/wiki/ISO_8601 in order to be parsed correctly by Liquibase. Liquibase will initially set the date format to be 'yyyy-MM-dd'T'HH:mm:ss' and then it checks for two special cases which will override the data format string.\n\nIf the string representing the date/time includes a '.', then the date format is changed to 'yyyy-MM-dd'T'HH:mm:ss.SSS'\nIf the string representing the date/time includes a space, then the date format is changed to 'yyyy-MM-dd HH:mm:ss'\nOnce the date format string is set, Liquibase will then call the SimpleDateFormat.parse() method attempting to parse the input string so that it can return a Date/Time. If problems occur, then a ParseException is thrown and the input string is treated as a String for the INSERT command to be generated.\nIf UUID type is used UUID value is stored as string and NULL in cell is supported. Column config should be used in xml.", priority=1, appliesTo={"table"}, since="1.7")
public class LoadDataChange
extends AbstractChange
implements ChangeWithColumns<LoadDataColumnConfig> {
    public static final String DEFAULT_COMMENT_PATTERN = "#";
    public static final Pattern BASE64_PATTERN = Pattern.compile("^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$");
    private static final Logger LOG = LogService.getLog(LoadDataChange.class);
    private static ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    private String catalogName;
    private String schemaName;
    private String tableName;
    private String file;
    private String commentLineStartsWith = "#";
    private Boolean relativeToChangelogFile;
    private String encoding;
    private String separator = ",";
    private String quotchar = "\"";
    private List<LoadDataColumnConfig> columns = new ArrayList<LoadDataColumnConfig>();
    private Boolean usePreparedStatements;

    protected static String getValueToWrite(Object value) {
        if (value == null || "NULL".equalsIgnoreCase(value.toString())) {
            return "";
        }
        return value.toString().trim();
    }

    protected boolean hasPreparedStatementsImplemented() {
        return true;
    }

    @Override
    public boolean supports(Database database) {
        return true;
    }

    @Override
    public boolean generateRollbackStatementsVolatile(Database database) {
        return true;
    }

    @DatabaseChangeProperty(since="3.0", mustEqualExisting="table.catalog")
    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @DatabaseChangeProperty(mustEqualExisting="table.schema")
    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @DatabaseChangeProperty(description="Name of the table to insert data into", requiredForDatabase={"all"}, mustEqualExisting="table")
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @DatabaseChangeProperty(description="CSV file to load", exampleValue="com/example/users.csv", requiredForDatabase={"all"})
    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public Boolean getUsePreparedStatements() {
        return this.usePreparedStatements;
    }

    public void setUsePreparedStatements(Boolean usePreparedStatements) {
        this.usePreparedStatements = usePreparedStatements;
    }

    public String getCommentLineStartsWith() {
        return this.commentLineStartsWith;
    }

    public void setCommentLineStartsWith(String commentLineStartsWith) {
        this.commentLineStartsWith = commentLineStartsWith == null ? DEFAULT_COMMENT_PATTERN : ("".equals(commentLineStartsWith) ? null : commentLineStartsWith);
    }

    public Boolean isRelativeToChangelogFile() {
        return this.relativeToChangelogFile;
    }

    public void setRelativeToChangelogFile(Boolean relativeToChangelogFile) {
        this.relativeToChangelogFile = relativeToChangelogFile;
    }

    @DatabaseChangeProperty(description="Encoding of the CSV file (defaults to UTF-8)", exampleValue="UTF-8")
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @DatabaseChangeProperty(exampleValue=",")
    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        if (separator != null && "\\t".equals(separator)) {
            separator = "\t";
        }
        this.separator = separator;
    }

    @DatabaseChangeProperty(exampleValue="'")
    public String getQuotchar() {
        return this.quotchar;
    }

    public void setQuotchar(String quotchar) {
        this.quotchar = quotchar;
    }

    @Override
    public void addColumn(LoadDataColumnConfig column) {
        this.columns.add(column);
    }

    @Override
    @DatabaseChangeProperty(description="Defines how the data should be loaded.", requiredForDatabase={"all"})
    public List<LoadDataColumnConfig> getColumns() {
        return this.columns;
    }

    @Override
    public void setColumns(List<LoadDataColumnConfig> columns) {
        this.columns = columns;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SqlStatement[] generateStatements(Database database) {
        boolean databaseSupportsBatchUpdates = false;
        try {
            databaseSupportsBatchUpdates = database.supportsBatchUpdates();
        }
        catch (DatabaseException e2) {
            throw new UnexpectedLiquibaseException(e2);
        }
        CSVReader reader = null;
        try {
            reader = this.getCSVReader();
            if (reader == null) {
                throw new UnexpectedLiquibaseException("Unable to read file " + this.getFile());
            }
            String[] headers = reader.readNext();
            if (headers == null) {
                throw new UnexpectedLiquibaseException("Data file " + this.getFile() + " was empty");
            }
            if (this.columns.isEmpty()) {
                this.columns.addAll(this.getColumnsFromHeaders(headers));
            }
            try {
                this.retrieveMissingColumnLoadTypes(this.columns, database);
            }
            catch (DatabaseException e3) {
                throw new UnexpectedLiquibaseException(e3);
            }
            ArrayList<ExecutablePreparedStatementBase> batchedStatements = new ArrayList<ExecutablePreparedStatementBase>();
            boolean anyPreparedStatements = false;
            int lineNumber = 1;
            boolean isCommentingEnabled = StringUtils.isNotEmpty(this.commentLineStartsWith);
            ArrayList<InsertStatement> statements = new ArrayList<InsertStatement>();
            while (true) {
                void var13_27;
                ArrayList columnsFromCsv;
                boolean needsPreparedStatement2;
                String[] line;
                if ((line = reader.readNext()) != null) {
                    ++lineNumber;
                    if (line.length == 0 || line.length == 1 && StringUtils.trimToNull(line[0]) == null || isCommentingEnabled && this.isLineCommented(line)) continue;
                    if (line.length != headers.length) {
                        throw new UnexpectedLiquibaseException("CSV file " + this.getFile() + " Line " + lineNumber + " has " + line.length + " values defined, Header has " + headers.length + ". Numbers MUST be equal (check for unquoted string with embedded commas)");
                    }
                    needsPreparedStatement2 = false;
                    if (this.usePreparedStatements != null && this.usePreparedStatements.booleanValue()) {
                        needsPreparedStatement2 = true;
                    }
                    columnsFromCsv = new ArrayList();
                    boolean bl2 = false;
                } else {
                    if (anyPreparedStatements) {
                        if (databaseSupportsBatchUpdates && statements.isEmpty() && !batchedStatements.isEmpty()) {
                            SqlStatement[] needsPreparedStatement2 = new SqlStatement[]{new BatchDmlExecutablePreparedStatement(database, this.getCatalogName(), this.getSchemaName(), this.getTableName(), this.columns, this.getChangeSet(), this.getResourceAccessor(), batchedStatements)};
                            return needsPreparedStatement2;
                        }
                        SqlStatement[] needsPreparedStatement2 = statements.toArray(new SqlStatement[statements.size()]);
                        return needsPreparedStatement2;
                    }
                    if (statements.isEmpty()) {
                        SqlStatement[] needsPreparedStatement2 = new SqlStatement[]{};
                        return needsPreparedStatement2;
                    }
                    InsertSetStatement statementSet = this.createStatementSet(this.getCatalogName(), this.getSchemaName(), this.getTableName());
                    for (SqlStatement sqlStatement : statements) {
                        statementSet.addInsertStatement((InsertStatement)sqlStatement);
                    }
                    if (database instanceof MSSQLDatabase || database instanceof MySQLDatabase || database instanceof PostgresDatabase) {
                        List<InsertStatement> innerStatements = statementSet.getStatements();
                        if (innerStatements != null && !innerStatements.isEmpty() && innerStatements.get(0) instanceof InsertOrUpdateStatement) {
                            SqlStatement[] sqlStatementArray = statementSet.getStatementsArray();
                            return sqlStatementArray;
                        }
                        SqlStatement[] sqlStatementArray = new SqlStatement[]{statementSet};
                        return sqlStatementArray;
                    }
                    SqlStatement[] sqlStatementArray = statementSet.getStatementsArray();
                    return sqlStatementArray;
                }
                while (var13_27 < headers.length) {
                    block82: {
                        ColumnConfig valueConfig;
                        block80: {
                            String columnName;
                            String value;
                            block81: {
                                block83: {
                                    ColumnConfig columnConfig;
                                    block90: {
                                        block89: {
                                            String sequenceName;
                                            block88: {
                                                block87: {
                                                    block86: {
                                                        block85: {
                                                            block84: {
                                                                value = line[var13_27];
                                                                columnName = headers[var13_27].trim();
                                                                valueConfig = new ColumnConfig();
                                                                columnConfig = this.getColumnConfig((int)var13_27, headers[var13_27].trim());
                                                                if ("NULL".equalsIgnoreCase(value.toString())) {
                                                                    valueConfig.setType(columnConfig.getType());
                                                                }
                                                                if (columnConfig == null) break block81;
                                                                if ("skip".equalsIgnoreCase(columnConfig.getType())) break block82;
                                                                if (columnConfig.getName() != null) {
                                                                    columnName = columnConfig.getName();
                                                                }
                                                                valueConfig.setName(columnName);
                                                                if (columnConfig.getType() == null) break block83;
                                                                if (!columnConfig.getType().equalsIgnoreCase(LOAD_DATA_TYPE.BOOLEAN.toString())) break block84;
                                                                if ("NULL".equalsIgnoreCase(value.toString())) {
                                                                    valueConfig.setValue(null);
                                                                    break block80;
                                                                } else {
                                                                    valueConfig.setValueBoolean(BooleanParser.parseBoolean(value.toString().toLowerCase()));
                                                                }
                                                                break block80;
                                                            }
                                                            if (!columnConfig.getType().equalsIgnoreCase(LOAD_DATA_TYPE.NUMERIC.toString())) break block85;
                                                            if ("NULL".equalsIgnoreCase(value.toString())) {
                                                                valueConfig.setValue(null);
                                                                break block80;
                                                            } else {
                                                                valueConfig.setValueNumeric(value.toString());
                                                            }
                                                            break block80;
                                                        }
                                                        if (!columnConfig.getType().toLowerCase().contains("date") && !columnConfig.getType().toLowerCase().contains("time")) break block86;
                                                        if ("NULL".equalsIgnoreCase(value.toString())) {
                                                            valueConfig.setValue(null);
                                                            break block80;
                                                        } else {
                                                            try {
                                                                valueConfig.setType(columnConfig.getType());
                                                                valueConfig.setValueDate(value.toString());
                                                            }
                                                            catch (DateParseException e4) {
                                                                throw new UnexpectedLiquibaseException(e4);
                                                            }
                                                        }
                                                    }
                                                    if (!columnConfig.getType().equalsIgnoreCase(LOAD_DATA_TYPE.STRING.toString())) break block87;
                                                    if ("NULL".equalsIgnoreCase(value.toString())) {
                                                        valueConfig.setType(columnConfig.getType());
                                                        valueConfig.setValue(null);
                                                        break block80;
                                                    } else {
                                                        valueConfig.setValue(value.toString());
                                                    }
                                                    break block80;
                                                }
                                                if (!columnConfig.getType().equalsIgnoreCase(LOAD_DATA_TYPE.COMPUTED.toString())) break block88;
                                                if ("NULL".equalsIgnoreCase(value.toString())) {
                                                    valueConfig.setValue(null);
                                                    break block80;
                                                } else {
                                                    DatabaseFunction function = new DatabaseFunction(value.toString());
                                                    valueConfig.setValueComputed(function);
                                                }
                                                break block80;
                                            }
                                            if (!columnConfig.getType().equalsIgnoreCase(LOAD_DATA_TYPE.SEQUENCE.toString())) break block89;
                                            if ("NULL".equalsIgnoreCase(value.toString())) {
                                                sequenceName = columnConfig.getDefaultValue();
                                                if (sequenceName == null) {
                                                    throw new UnexpectedLiquibaseException("Must set a sequence name in the loadData column defaultValue attribute");
                                                }
                                            } else {
                                                sequenceName = value.toString();
                                            }
                                            SequenceNextValueFunction function = new SequenceNextValueFunction(sequenceName);
                                            valueConfig.setValueComputed(function);
                                            break block80;
                                        }
                                        if (!columnConfig.getType().equalsIgnoreCase(LOAD_DATA_TYPE.BLOB.toString())) break block90;
                                        if ("NULL".equalsIgnoreCase(value.toString())) {
                                            valueConfig.setValue(null);
                                            break block80;
                                        } else if (BASE64_PATTERN.matcher(value.toString()).matches()) {
                                            valueConfig.setType(columnConfig.getType());
                                            valueConfig.setValue(value.toString());
                                            needsPreparedStatement2 = true;
                                            break block80;
                                        } else {
                                            valueConfig.setValueBlobFile(value.toString());
                                            needsPreparedStatement2 = true;
                                        }
                                        break block80;
                                    }
                                    if (columnConfig.getType().equalsIgnoreCase(LOAD_DATA_TYPE.CLOB.toString())) {
                                        if ("NULL".equalsIgnoreCase(value.toString())) {
                                            valueConfig.setValue(null);
                                            break block80;
                                        } else {
                                            valueConfig.setValueClobFile(value.toString());
                                            needsPreparedStatement2 = true;
                                        }
                                        break block80;
                                    } else {
                                        if (!columnConfig.getType().equalsIgnoreCase(LOAD_DATA_TYPE.UUID.toString())) {
                                            throw new UnexpectedLiquibaseException(String.format(coreBundle.getString("loaddata.type.is.not.supported"), columnConfig.getType()));
                                        }
                                        valueConfig.setType(columnConfig.getType());
                                        if ("NULL".equalsIgnoreCase(value.toString())) {
                                            valueConfig.setValue(null);
                                            break block80;
                                        } else {
                                            valueConfig.setValue(value.toString());
                                        }
                                    }
                                    break block80;
                                }
                                valueConfig.setValue(LoadDataChange.getValueToWrite(value));
                                break block80;
                            }
                            if (columnName.contains("(") || columnName.contains(")") && database instanceof AbstractJdbcDatabase) {
                                columnName = ((AbstractJdbcDatabase)database).quoteObject(columnName, Column.class);
                            }
                            valueConfig.setName(columnName);
                            valueConfig.setValue(LoadDataChange.getValueToWrite(value));
                        }
                        columnsFromCsv.add(valueConfig);
                    }
                    ++var13_27;
                }
                if ((needsPreparedStatement2 || databaseSupportsBatchUpdates && ExecutorService.getInstance().executorExists("logging", database) && !(ExecutorService.getInstance().getExecutor("logging", database) instanceof LoggingExecutor)) && this.hasPreparedStatementsImplemented()) {
                    anyPreparedStatements = true;
                    ExecutablePreparedStatementBase executablePreparedStatementBase = this.createPreparedStatement(database, this.getCatalogName(), this.getSchemaName(), this.getTableName(), columnsFromCsv, this.getChangeSet(), this.getResourceAccessor());
                    batchedStatements.add(executablePreparedStatementBase);
                    continue;
                }
                InsertStatement insertStatement = this.createStatement(this.getCatalogName(), this.getSchemaName(), this.getTableName());
                Iterator iterator = columnsFromCsv.iterator();
                while (iterator.hasNext()) {
                    ColumnConfig column = (ColumnConfig)iterator.next();
                    String columnName = column.getName();
                    Object value = column.getValueObject();
                    if (value == null) {
                        value = "NULL";
                    }
                    insertStatement.addColumnValue(columnName, value);
                }
                statements.add(insertStatement);
            }
        }
        catch (IOException e5) {
            throw new RuntimeException(e5);
        }
        catch (UnexpectedLiquibaseException ule) {
            if (this.getChangeSet() == null) throw ule;
            if (this.getChangeSet().getFailOnError() == null) throw ule;
            if (this.getChangeSet().getFailOnError() != false) throw ule;
            LOG.info(LogType.LOG, "Change set " + this.getChangeSet().toString(false) + " failed, but failOnError was false.  Error: " + ule.getMessage());
            SqlStatement[] sqlStatementArray = new SqlStatement[]{};
            return sqlStatementArray;
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void retrieveMissingColumnLoadTypes(List<LoadDataColumnConfig> columns, Database database) throws DatabaseException {
        Table snapshotOfTable;
        boolean matched = false;
        for (LoadDataColumnConfig c2 : columns) {
            if (c2.getType() != null) continue;
            matched = true;
        }
        if (!matched) {
            return;
        }
        CatalogAndSchema catalogAndSchema = new CatalogAndSchema(this.getCatalogName(), this.getSchemaName());
        catalogAndSchema = catalogAndSchema.standardize(database);
        Table targetTable = new Table(catalogAndSchema.getCatalogName(), catalogAndSchema.getSchemaName(), database.correctObjectName(this.getTableName(), Table.class));
        try {
            snapshotOfTable = SnapshotGeneratorFactory.getInstance().createSnapshot(targetTable, database);
        }
        catch (InvalidExampleException e2) {
            throw new DatabaseException(e2);
        }
        if (snapshotOfTable == null) {
            LOG.warning(LogType.LOG, String.format(coreBundle.getString("could.not.snapshot.table.to.get.the.missing.column.type.information"), database.escapeTableName(targetTable.getSchema().getCatalogName(), targetTable.getSchema().getName(), targetTable.getName())));
            return;
        }
        HashMap<String, Column> tableColumns = new HashMap<String, Column>();
        for (Column c3 : snapshotOfTable.getColumns()) {
            tableColumns.put(database.correctObjectName(c3.getName(), Column.class), c3);
        }
        HashMap<String, LoadDataColumnConfig> columnConfigs = new HashMap<String, LoadDataColumnConfig>();
        for (LoadDataColumnConfig loadDataColumnConfig : columns) {
            columnConfigs.put(database.correctObjectName(loadDataColumnConfig.getName(), Column.class), loadDataColumnConfig);
        }
        for (Map.Entry entry : columnConfigs.entrySet()) {
            if (((LoadDataColumnConfig)entry.getValue()).getType() != null) continue;
            LoadDataColumnConfig columnConfig = (LoadDataColumnConfig)entry.getValue();
            DataType dataType = ((Column)tableColumns.get(entry.getKey())).getType();
            if (dataType == null) {
                LOG.warning(LogType.LOG, String.format(coreBundle.getString("unable.to.find.load.data.type"), columnConfig.toString(), snapshotOfTable.toString()));
                columnConfig.setType(LOAD_DATA_TYPE.STRING.toString());
                continue;
            }
            LiquibaseDataType liquibaseDataType = DataTypeFactory.getInstance().fromDescription(dataType.toString(), database);
            if (liquibaseDataType != null) {
                columnConfig.setType(liquibaseDataType.getLoadTypeName().toString());
                continue;
            }
            LOG.warning(LogType.LOG, String.format(coreBundle.getString("unable.to.convert.load.data.type"), columnConfig.toString(), snapshotOfTable.toString(), dataType.toString()));
        }
    }

    private List<LoadDataColumnConfig> getColumnsFromHeaders(String[] headers) {
        ArrayList<LoadDataColumnConfig> result = new ArrayList<LoadDataColumnConfig>();
        int i2 = 0;
        for (String columnNameFromHeader : headers) {
            LoadDataColumnConfig loadDataColumnConfig = new LoadDataColumnConfig();
            loadDataColumnConfig.setIndex(i2);
            loadDataColumnConfig.setHeader(columnNameFromHeader);
            loadDataColumnConfig.setName(columnNameFromHeader);
            result.add(loadDataColumnConfig);
            ++i2;
        }
        return result;
    }

    private boolean isLineCommented(String[] line) {
        return StringUtils.startsWith(line[0], this.commentLineStartsWith);
    }

    @Override
    public boolean generateStatementsVolatile(Database database) {
        return true;
    }

    public CSVReader getCSVReader() throws IOException {
        ResourceAccessor resourceAccessor = this.getResourceAccessor();
        if (resourceAccessor == null) {
            throw new UnexpectedLiquibaseException("No file resourceAccessor specified for " + this.getFile());
        }
        InputStream stream = StreamUtil.openStream(this.file, this.isRelativeToChangelogFile(), this.getChangeSet(), resourceAccessor);
        if (stream == null) {
            return null;
        }
        UtfBomAwareReader streamReader = this.getEncoding() == null ? new UtfBomAwareReader(stream) : new UtfBomAwareReader(stream, this.getEncoding());
        char quotchar = StringUtils.trimToEmpty(this.quotchar).isEmpty() ? (char)'\u0001' : this.quotchar.charAt(0);
        if (this.separator == null) {
            this.separator = ",";
        }
        return new CSVReader((Reader)streamReader, this.separator.charAt(0), quotchar);
    }

    protected ExecutablePreparedStatementBase createPreparedStatement(Database database, String catalogName, String schemaName, String tableName, List<ColumnConfig> columns, ChangeSet changeSet, ResourceAccessor resourceAccessor) {
        return new InsertExecutablePreparedStatement(database, catalogName, schemaName, tableName, columns, changeSet, resourceAccessor);
    }

    protected InsertStatement createStatement(String catalogName, String schemaName, String tableName) {
        return new InsertStatement(catalogName, schemaName, tableName);
    }

    protected InsertSetStatement createStatementSet(String catalogName, String schemaName, String tableName) {
        return new InsertSetStatement(catalogName, schemaName, tableName);
    }

    protected ColumnConfig getColumnConfig(int index, String header) {
        for (LoadDataColumnConfig config : this.columns) {
            if (config.getIndex() != null && config.getIndex().equals(index)) {
                return config;
            }
            if (config.getHeader() != null && config.getHeader().equalsIgnoreCase(header)) {
                return config;
            }
            if (config.getName() == null || !config.getName().equalsIgnoreCase(header)) continue;
            return config;
        }
        return null;
    }

    @Override
    public ChangeStatus checkStatus(Database database) {
        return new ChangeStatus().unknown("Cannot check loadData status");
    }

    @Override
    public String getConfirmationMessage() {
        return "Data loaded from " + this.getFile() + " into " + this.getTableName();
    }

    @Override
    public CheckSum generateCheckSum() {
        InputStream stream = null;
        try {
            stream = StreamUtil.openStream(this.file, this.isRelativeToChangelogFile(), this.getChangeSet(), this.getResourceAccessor());
            if (stream == null) {
                throw new UnexpectedLiquibaseException(this.getFile() + " could not be found");
            }
            stream = new EmptyLineAndCommentSkippingInputStream(stream, this.commentLineStartsWith);
            CheckSum checkSum = CheckSum.compute(this.getTableName() + ":" + CheckSum.compute(stream, true));
            return checkSum;
        }
        catch (IOException e2) {
            throw new UnexpectedLiquibaseException(e2);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public Warnings warn(Database database) {
        return null;
    }

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/dbchangelog";
    }

    public static enum LOAD_DATA_TYPE {
        BOOLEAN,
        NUMERIC,
        DATE,
        STRING,
        COMPUTED,
        SEQUENCE,
        BLOB,
        CLOB,
        SKIP,
        UUID;

    }
}

