/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.function.postgres;

import com.datical.liquibase.ext.storedlogic.AbstractStoredDatabaseLogicSnapshotGenerator;
import com.datical.liquibase.ext.storedlogic.function.Function;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import liquibase.database.Database;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.structure.core.StoredDatabaseLogic;
import liquibase.util.StringUtil;

public class PostgresFunctionSnapshotGenerator
extends AbstractStoredDatabaseLogicSnapshotGenerator {
    private static final Map<String, String> ARGUMENT_MODE_MAPPING = new HashMap<String, String>();

    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        return -1;
    }

    public PostgresFunctionSnapshotGenerator() {
        super(Function.class, new Class[]{Schema.class});
    }

    @Override
    protected String getObjectType(Database database) {
        return "FUNCTION";
    }

    protected StoredDatabaseLogic<Function> createReturnObject() {
        return new Function();
    }

    @Override
    public String getAddToSql(Schema schema, Database database) {
        boolean bl2;
        try {
            bl2 = database.getDatabaseMajorVersion() > 10;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return "select   pp.proname AS OBJECT_NAME,  pg_get_function_arguments(pp.oid) AS OBJECT_ARG,   CASE pg_ag.aggtranstype is null     WHEN true THEN pg_get_functiondef(pp.oid)    ELSE format(E'CREATE AGGREGATE %s.%s(%s) (\\n%s\\n);',      pn.nspname, pp.proname, pg_get_function_arguments(pp.oid),      array_to_string(        ARRAY[         format(E'\\tSFUNC = %s', aggtransfn::regproc)         , format(E'\\tSTYPE = %s', format_type(aggtranstype, NULL))         , CASE aggfinalfn WHEN '-'::regproc THEN NULL ELSE format(E'\\tFINALFUNC = %s',aggfinalfn::text) END         , CASE aggsortop WHEN 0 THEN NULL ELSE format(E'\\tSORTOP = %s', oprname) END         , CASE WHEN agginitval IS NULL THEN NULL ELSE format(E'\\tINITCOND = %s', agginitval) END          ]          , E',\\n'       )    )    END   AS OBJECT_BODY from pg_proc pp join pg_namespace pn on (pp.pronamespace = pn.oid) join pg_language pl on (pp.prolang = pl.oid) left join pg_aggregate pg_ag ON pg_ag.aggfnoid = pp.oid left join pg_operator pg_op ON pg_ag.aggsortop = pg_op.oid where   pn.nspname NOT LIKE 'pg_%'   and pn.nspname = '" + schema.getName() + "' " + (bl2 ? " and pp.prokind in ('f', 'a') " : "");
    }

    @Override
    public String getSnapshotObjectSql(StoredDatabaseLogic<?> function, Database object) {
        function = function;
        object = this.getAddToSql(function.getSchema(), (Database)object);
        return String.format("%s and pp.proname = '%s' ", object, function.getName());
    }

    @Override
    public void addTo(DatabaseObject databaseObject, DatabaseSnapshot iterator) {
        if (!(databaseObject instanceof Schema)) {
            return;
        }
        databaseObject = (Schema)databaseObject;
        Database object2 = ((DatabaseSnapshot)((Object)iterator)).getDatabase();
        Executor executor = ExecutorService.getInstance().getExecutor(object2);
        iterator = this.queryForList((DatabaseSnapshot)((Object)iterator), (Schema)databaseObject, executor);
        for (StoredDatabaseLogic storedDatabaseLogic : this.toObjects((Schema)databaseObject, (List<Map<String, ?>>)((Object)iterator))) {
            ((Schema)databaseObject).addDatabaseObject(storedDatabaseLogic);
        }
    }

    @Override
    public StoredDatabaseLogic performSnapshotAndBuildStoredObject(Database list, StoredDatabaseLogic<?> storedDatabaseLogic) {
        if (StringUtil.isNotEmpty(storedDatabaseLogic.getBody())) {
            return storedDatabaseLogic;
        }
        String object2 = this.getSnapshotObjectSql(storedDatabaseLogic, (Database)((Object)list));
        list = ExecutorService.getInstance().getExecutor((Database)((Object)list)).queryForList(new RawSqlStatement(object2));
        list = this.castToListOfMaps(list);
        list = this.toObjects(storedDatabaseLogic.getSchema(), list);
        if (list.size() == 1) {
            return (StoredDatabaseLogic)list.get(0);
        }
        for (StoredDatabaseLogic storedDatabaseLogic2 : list) {
            if (!storedDatabaseLogic2.getName().equals(storedDatabaseLogic.getName())) continue;
            return storedDatabaseLogic2;
        }
        return null;
    }

    private List<StoredDatabaseLogic> toObjects(Schema schema, List<Map<String, ?>> object) {
        ArrayList<StoredDatabaseLogic> arrayList = new ArrayList<StoredDatabaseLogic>();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (Map)object.next();
            String string = (String)object2.get("OBJECT_NAME");
            String string2 = (String)object2.get("OBJECT_BODY");
            object2 = (String)object2.get("OBJECT_ARG");
            object2 = String.format("%s(%s)", string, StringUtil.trimToEmpty((String)object2));
            object2 = ((Function)((Function)((Function)this.createReturnObject().setSchema(schema).setName((String)object2)).setBody(string2)).setValid(Boolean.TRUE)).setFunctionName(string);
            arrayList.add((StoredDatabaseLogic)object2);
        }
        return arrayList;
    }

    static {
        ARGUMENT_MODE_MAPPING.put("i", "IN");
        ARGUMENT_MODE_MAPPING.put("o", "OUT");
        ARGUMENT_MODE_MAPPING.put("b", "INOUT");
        ARGUMENT_MODE_MAPPING.put("t", "TABLE");
        ARGUMENT_MODE_MAPPING.put("v", "VARIADIC");
    }
}

