/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import liquibase.ContextExpression;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.IncludeAllFilter;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.ContextChangeSetFilter;
import liquibase.changelog.filter.DbmsChangeSetFilter;
import liquibase.changelog.filter.LabelChangeSetFilter;
import liquibase.changelog.visitor.ValidatingVisitor;
import liquibase.database.Database;
import liquibase.database.DatabaseList;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.exception.LiquibaseException;
import liquibase.exception.SetupException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.UnknownChangelogFormatException;
import liquibase.exception.ValidationFailedException;
import liquibase.logging.Logger;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.parser.core.ParsedNode;
import liquibase.parser.core.ParsedNodeException;
import liquibase.precondition.Conditional;
import liquibase.precondition.core.PreconditionContainer;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StringUtil;
import liquibase.util.file.FilenameUtils;

public class DatabaseChangeLog
implements Comparable<DatabaseChangeLog>,
Conditional {
    private static final ThreadLocal<DatabaseChangeLog> ROOT_CHANGE_LOG = new ThreadLocal();
    private static final ThreadLocal<DatabaseChangeLog> PARENT_CHANGE_LOG = new ThreadLocal();
    private static final Logger LOG = Scope.getCurrentScope().getLog(DatabaseChangeLog.class);
    private PreconditionContainer preconditionContainer = new PreconditionContainer();
    private String physicalFilePath;
    private String logicalFilePath;
    private ObjectQuotingStrategy objectQuotingStrategy;
    private List<ChangeSet> changeSets = new ArrayList<ChangeSet>();
    private ChangeLogParameters changeLogParameters;
    private RuntimeEnvironment runtimeEnvironment;
    private DatabaseChangeLog rootChangeLog = ROOT_CHANGE_LOG.get();
    private DatabaseChangeLog parentChangeLog = PARENT_CHANGE_LOG.get();
    private ContextExpression contexts;
    private ContextExpression includeContexts;
    private LabelExpression includeLabels;
    private boolean includeIgnore;

    public DatabaseChangeLog() {
    }

    public DatabaseChangeLog(String physicalFilePath) {
        this.physicalFilePath = physicalFilePath;
    }

    public void setRootChangeLog(DatabaseChangeLog rootChangeLog) {
        this.rootChangeLog = rootChangeLog;
    }

    public DatabaseChangeLog getRootChangeLog() {
        return this.rootChangeLog != null ? this.rootChangeLog : this;
    }

    public void setParentChangeLog(DatabaseChangeLog parentChangeLog) {
        this.parentChangeLog = parentChangeLog;
    }

    public DatabaseChangeLog getParentChangeLog() {
        return this.parentChangeLog;
    }

    public RuntimeEnvironment getRuntimeEnvironment() {
        return this.runtimeEnvironment;
    }

    public void setRuntimeEnvironment(RuntimeEnvironment runtimeEnvironment) {
        this.runtimeEnvironment = runtimeEnvironment;
    }

    @Override
    public PreconditionContainer getPreconditions() {
        return this.preconditionContainer;
    }

    @Override
    public void setPreconditions(PreconditionContainer precond) {
        this.preconditionContainer = precond == null ? new PreconditionContainer() : precond;
    }

    public ChangeLogParameters getChangeLogParameters() {
        return this.changeLogParameters;
    }

    public void setChangeLogParameters(ChangeLogParameters changeLogParameters) {
        this.changeLogParameters = changeLogParameters;
    }

    public String getPhysicalFilePath() {
        return this.physicalFilePath;
    }

    public void setPhysicalFilePath(String physicalFilePath) {
        this.physicalFilePath = physicalFilePath;
    }

    public String getLogicalFilePath() {
        String returnPath = this.logicalFilePath;
        if (this.logicalFilePath == null) {
            returnPath = this.physicalFilePath;
        }
        return returnPath.replaceAll("\\\\", "/").replaceFirst("^/", "");
    }

    public void setLogicalFilePath(String logicalFilePath) {
        this.logicalFilePath = logicalFilePath;
    }

    public String getFilePath() {
        if (this.logicalFilePath == null) {
            return this.physicalFilePath;
        }
        return this.getLogicalFilePath();
    }

    public ObjectQuotingStrategy getObjectQuotingStrategy() {
        return this.objectQuotingStrategy;
    }

    public void setObjectQuotingStrategy(ObjectQuotingStrategy objectQuotingStrategy) {
        this.objectQuotingStrategy = objectQuotingStrategy;
    }

    public ContextExpression getContexts() {
        return this.contexts;
    }

    public void setContexts(ContextExpression contexts) {
        this.contexts = contexts;
    }

    public ContextExpression getIncludeContexts() {
        return this.includeContexts;
    }

    public void setIncludeLabels(LabelExpression labels) {
        this.includeLabels = labels;
    }

    public LabelExpression getIncludeLabels() {
        return this.includeLabels;
    }

    public void setIncludeIgnore(boolean ignore) {
        this.includeIgnore = ignore;
    }

    public boolean isIncludeIgnore() {
        return this.includeIgnore;
    }

    public void setIncludeContexts(ContextExpression includeContexts) {
        this.includeContexts = includeContexts;
    }

    public String toString() {
        return this.getFilePath();
    }

    @Override
    public int compareTo(DatabaseChangeLog o2) {
        return this.getFilePath().compareTo(o2.getFilePath());
    }

    public ChangeSet getChangeSet(String path, String author, String id2) {
        for (ChangeSet changeSet : this.changeSets) {
            if (!DatabaseChangeLog.normalizePath(changeSet.getFilePath()).equalsIgnoreCase(DatabaseChangeLog.normalizePath(path)) || !changeSet.getAuthor().equalsIgnoreCase(author) || !changeSet.getId().equalsIgnoreCase(id2) || !this.isDbmsMatch(changeSet.getDbmsSet())) continue;
            return changeSet;
        }
        return null;
    }

    public List<ChangeSet> getChangeSets() {
        return this.changeSets;
    }

    public void addChangeSet(ChangeSet changeSet) {
        if (changeSet.getRunOrder() == null) {
            ListIterator<ChangeSet> it2 = this.changeSets.listIterator(this.changeSets.size());
            boolean added = false;
            while (it2.hasPrevious() && !added) {
                if ("last".equals(it2.previous().getRunOrder())) continue;
                it2.next();
                it2.add(changeSet);
                added = true;
            }
            if (!added) {
                it2.add(changeSet);
            }
        } else if ("first".equals(changeSet.getRunOrder())) {
            ListIterator<ChangeSet> it3 = this.changeSets.listIterator();
            boolean added = false;
            while (it3.hasNext() && !added) {
                if ("first".equals(it3.next().getRunOrder())) continue;
                it3.previous();
                it3.add(changeSet);
                added = true;
            }
            if (!added) {
                this.changeSets.add(changeSet);
            }
        } else if ("last".equals(changeSet.getRunOrder())) {
            this.changeSets.add(changeSet);
        } else {
            throw new UnexpectedLiquibaseException("Unknown runOrder: " + changeSet.getRunOrder());
        }
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        DatabaseChangeLog that = (DatabaseChangeLog)o2;
        return this.getFilePath().equals(that.getFilePath());
    }

    public int hashCode() {
        return this.getFilePath().hashCode();
    }

    public void validate(Database database, String ... contexts) throws LiquibaseException {
        this.validate(database, new Contexts(contexts), new LabelExpression());
    }

    public void validate(Database database, Contexts contexts, LabelExpression labelExpression) throws LiquibaseException {
        database.setObjectQuotingStrategy(this.objectQuotingStrategy);
        ChangeLogIterator logIterator = new ChangeLogIterator(this, new DbmsChangeSetFilter(database), new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression));
        ValidatingVisitor validatingVisitor = new ValidatingVisitor(database.getRanChangeSetList());
        validatingVisitor.validate(database, this);
        logIterator.run(validatingVisitor, new RuntimeEnvironment(database, contexts, labelExpression));
        for (String message : validatingVisitor.getWarnings().getMessages()) {
            Scope.getCurrentScope().getLog(this.getClass()).warning(message);
        }
        if (!validatingVisitor.validationPassed()) {
            throw new ValidationFailedException(validatingVisitor);
        }
    }

    public ChangeSet getChangeSet(RanChangeSet ranChangeSet) {
        return this.getChangeSet(ranChangeSet.getChangeLog(), ranChangeSet.getAuthor(), ranChangeSet.getId());
    }

    public void load(ParsedNode parsedNode, ResourceAccessor resourceAccessor) throws ParsedNodeException, SetupException {
        this.setLogicalFilePath(parsedNode.getChildValue((String)null, "logicalFilePath", String.class));
        this.setContexts(new ContextExpression(parsedNode.getChildValue((String)null, "context", String.class)));
        String objectQuotingStrategy = parsedNode.getChildValue((String)null, "objectQuotingStrategy", String.class);
        if (objectQuotingStrategy != null) {
            this.setObjectQuotingStrategy(ObjectQuotingStrategy.valueOf(objectQuotingStrategy));
        }
        for (ParsedNode childNode : parsedNode.getChildren()) {
            this.handleChildNode(childNode, resourceAccessor);
        }
    }

    protected void expandExpressions(ParsedNode parsedNode) {
        if (this.changeLogParameters == null) {
            return;
        }
        try {
            List<ParsedNode> children;
            Object value = parsedNode.getValue();
            if (value != null && value instanceof String) {
                parsedNode.setValue(this.changeLogParameters.expandExpressions(parsedNode.getValue(String.class), this));
            }
            if ((children = parsedNode.getChildren()) != null) {
                for (ParsedNode child : children) {
                    this.expandExpressions(child);
                }
            }
        }
        catch (ParsedNodeException e2) {
            throw new UnexpectedLiquibaseException(e2);
        }
    }

    protected void handleChildNode(ParsedNode node, ResourceAccessor resourceAccessor) throws ParsedNodeException, SetupException {
        String nodeName;
        this.expandExpressions(node);
        switch (nodeName = node.getName()) {
            case "changeSet": {
                if (!this.isDbmsMatch(node.getChildValue((String)null, "dbms", String.class))) break;
                this.addChangeSet(this.createChangeSet(node, resourceAccessor));
                break;
            }
            case "include": {
                String path = node.getChildValue((String)null, "file", String.class);
                if (path == null) {
                    throw new UnexpectedLiquibaseException("No 'file' attribute on 'include'");
                }
                path = path.replace('\\', '/');
                ContextExpression includeContexts = new ContextExpression(node.getChildValue((String)null, "context", String.class));
                LabelExpression labelExpression = new LabelExpression(node.getChildValue((String)null, "labels", String.class));
                Boolean ignore = node.getChildValue((String)null, "ignore", Boolean.class);
                try {
                    this.include(path, node.getChildValue(null, "relativeToChangelogFile", false), resourceAccessor, includeContexts, labelExpression, ignore, true);
                    break;
                }
                catch (LiquibaseException e2) {
                    throw new SetupException(e2);
                }
            }
            case "includeAll": {
                Boolean ignore;
                String path = node.getChildValue((String)null, "path", String.class);
                String resourceFilterDef = node.getChildValue((String)null, "filter", String.class);
                if (resourceFilterDef == null) {
                    resourceFilterDef = node.getChildValue((String)null, "resourceFilter", String.class);
                }
                IncludeAllFilter resourceFilter = null;
                if (resourceFilterDef != null) {
                    try {
                        resourceFilter = (IncludeAllFilter)Class.forName(resourceFilterDef).getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (ReflectiveOperationException e3) {
                        throw new SetupException(e3);
                    }
                }
                String resourceComparatorDef = node.getChildValue((String)null, "resourceComparator", String.class);
                Comparator<String> resourceComparator = null;
                if (resourceComparatorDef != null) {
                    try {
                        resourceComparator = (Comparator<String>)Class.forName(resourceComparatorDef).getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (ReflectiveOperationException e4) {
                        Scope.getCurrentScope().getLog(this.getClass()).info("no resourceComparator defined - taking default implementation");
                        resourceComparator = this.getStandardChangeLogComparator();
                    }
                }
                ContextExpression includeContexts = new ContextExpression(node.getChildValue((String)null, "context", String.class));
                LabelExpression labelExpression = new LabelExpression(node.getChildValue((String)null, "labels", String.class));
                if (labelExpression == null) {
                    labelExpression = new LabelExpression();
                }
                if ((ignore = node.getChildValue((String)null, "ignore", Boolean.class)) == null) {
                    ignore = false;
                }
                this.includeAll(path, node.getChildValue(null, "relativeToChangelogFile", false), resourceFilter, node.getChildValue(null, "errorIfMissingOrEmpty", true), resourceComparator, resourceAccessor, includeContexts, labelExpression, ignore);
                break;
            }
            case "preConditions": {
                this.preconditionContainer = new PreconditionContainer();
                try {
                    this.preconditionContainer.load(node, resourceAccessor);
                }
                catch (ParsedNodeException e5) {
                    e5.printStackTrace();
                }
                break;
            }
            case "property": {
                try {
                    String file;
                    String context = node.getChildValue((String)null, "context", String.class);
                    String dbms = node.getChildValue((String)null, "dbms", String.class);
                    String labels = node.getChildValue((String)null, "labels", String.class);
                    Boolean global = node.getChildValue((String)null, "global", Boolean.class);
                    if (global == null) {
                        global = true;
                    }
                    if ((file = node.getChildValue((String)null, "file", String.class)) == null) {
                        String name = node.getChildValue((String)null, "name", String.class);
                        String value = node.getChildValue((String)null, "value", String.class);
                        this.changeLogParameters.set(name, value, context, labels, dbms, (boolean)global, this);
                        break;
                    }
                    Properties props = new Properties();
                    InputStream propertiesStream = resourceAccessor.openStream(null, file);
                    if (propertiesStream == null) {
                        Scope.getCurrentScope().getLog(this.getClass()).info("Could not open properties file " + file);
                        break;
                    }
                    props.load(propertiesStream);
                    for (Map.Entry<Object, Object> entry : props.entrySet()) {
                        this.changeLogParameters.set(entry.getKey().toString(), entry.getValue().toString(), context, labels, dbms, (boolean)global, this);
                    }
                    break;
                }
                catch (IOException e6) {
                    throw new ParsedNodeException(e6);
                }
            }
        }
    }

    public boolean isDbmsMatch(String dbmsList) {
        return this.isDbmsMatch(DatabaseList.toDbmsSet(dbmsList));
    }

    public boolean isDbmsMatch(Set<String> dbmsSet) {
        return dbmsSet == null || this.changeLogParameters == null || this.changeLogParameters.getValue("database.typeName", this) == null || DatabaseList.definitionMatches(dbmsSet, this.changeLogParameters.getValue("database.typeName", this).toString(), true);
    }

    public void includeAll(String pathName, boolean isRelativeToChangelogFile, IncludeAllFilter resourceFilter, boolean errorIfMissingOrEmpty, Comparator<String> resourceComparator, ResourceAccessor resourceAccessor, ContextExpression includeContexts, LabelExpression labelExpression, boolean ignore) throws SetupException {
        try {
            SortedSet<String> unsortedResources;
            block11: {
                if (pathName == null) {
                    throw new SetupException("No path attribute for includeAll");
                }
                if (!(pathName = pathName.replace('\\', '/')).endsWith("/")) {
                    pathName = pathName + '/';
                }
                LOG.fine("includeAll for " + pathName);
                LOG.fine("Using file opener for includeAll: " + resourceAccessor.toString());
                String relativeTo = null;
                if (isRelativeToChangelogFile) {
                    relativeTo = this.getPhysicalFilePath();
                }
                unsortedResources = null;
                try {
                    unsortedResources = resourceAccessor.list(relativeTo, pathName, true, true, false);
                }
                catch (IOException e2) {
                    if (!errorIfMissingOrEmpty) break block11;
                    throw e2;
                }
            }
            TreeSet<String> resources = new TreeSet<String>(resourceComparator);
            if (unsortedResources != null) {
                for (String resourcePath : unsortedResources) {
                    if (resourceFilter != null && !resourceFilter.include(resourcePath)) continue;
                    resources.add(resourcePath);
                }
            }
            if (resources.isEmpty() && errorIfMissingOrEmpty) {
                throw new SetupException("Could not find directory or directory was empty for includeAll '" + pathName + "'");
            }
            for (String path : resources) {
                Scope.getCurrentScope().getLog(this.getClass()).info("Reading resource: " + path);
                this.include(path, false, resourceAccessor, includeContexts, labelExpression, ignore, false);
            }
        }
        catch (Exception e3) {
            throw new SetupException(e3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean include(String fileName, boolean isRelativePath, ResourceAccessor resourceAccessor, ContextExpression includeContexts, LabelExpression labelExpression, Boolean ignore, boolean logEveryUnknownFileFormat) throws LiquibaseException {
        DatabaseChangeLog changeLog;
        if (".svn".equalsIgnoreCase(fileName) || "cvs".equalsIgnoreCase(fileName)) {
            return false;
        }
        String relativeBaseFileName = this.getPhysicalFilePath();
        if (isRelativePath) {
            String tempFile = FilenameUtils.concat(FilenameUtils.getFullPath(relativeBaseFileName), fileName);
            fileName = tempFile != null && new File(tempFile).exists() ? tempFile : FilenameUtils.getFullPath(relativeBaseFileName) + fileName;
        }
        fileName = fileName.replaceFirst("classpath:", "");
        try {
            DatabaseChangeLog rootChangeLog = ROOT_CHANGE_LOG.get();
            if (rootChangeLog == null) {
                ROOT_CHANGE_LOG.set(this);
            }
            DatabaseChangeLog parentChangeLog = PARENT_CHANGE_LOG.get();
            PARENT_CHANGE_LOG.set(this);
            try {
                ChangeLogParser parser = ChangeLogParserFactory.getInstance().getParser(fileName, resourceAccessor);
                changeLog = parser.parse(fileName, this.changeLogParameters, resourceAccessor);
                changeLog.setIncludeContexts(includeContexts);
                changeLog.setIncludeLabels(labelExpression);
                changeLog.setIncludeIgnore(ignore != null ? ignore : false);
            }
            finally {
                if (rootChangeLog == null) {
                    ROOT_CHANGE_LOG.remove();
                }
                if (parentChangeLog == null) {
                    PARENT_CHANGE_LOG.remove();
                } else {
                    PARENT_CHANGE_LOG.set(parentChangeLog);
                }
            }
        }
        catch (UnknownChangelogFormatException e2) {
            boolean matchesFileExtension = StringUtil.trimToEmpty(fileName).matches("\\.\\w+$");
            if (matchesFileExtension || logEveryUnknownFileFormat) {
                Scope.getCurrentScope().getLog(this.getClass()).warning("included file " + relativeBaseFileName + "/" + fileName + " is not a recognized file type");
            }
            return false;
        }
        PreconditionContainer preconditions = changeLog.getPreconditions();
        if (preconditions != null) {
            if (null == this.getPreconditions()) {
                this.setPreconditions(new PreconditionContainer());
            }
            this.getPreconditions().addNestedPrecondition(preconditions);
        }
        for (ChangeSet changeSet : changeLog.getChangeSets()) {
            this.addChangeSet(changeSet);
        }
        return true;
    }

    protected ChangeSet createChangeSet(ParsedNode node, ResourceAccessor resourceAccessor) throws ParsedNodeException {
        ChangeSet changeSet = new ChangeSet(this);
        changeSet.setChangeLogParameters(this.getChangeLogParameters());
        changeSet.load(node, resourceAccessor);
        return changeSet;
    }

    protected Comparator<String> getStandardChangeLogComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.replace("WEB-INF/classes/", "").compareTo(o2.replace("WEB-INF/classes/", ""));
            }
        };
    }

    public static String normalizePath(String filePath) {
        if (filePath == null) {
            return null;
        }
        return filePath.replaceFirst("^classpath:", "").replaceAll("\\\\", "/").replaceAll("//+", "/").replaceFirst("^/", "");
    }

    public void clearCheckSums() {
        for (ChangeSet changeSet : this.getChangeSets()) {
            changeSet.clearCheckSum();
        }
    }
}

