/*
 * Decompiled with CFR 0.152.
 */
package liquibase.executor;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.Executor;

public class ExecutorService {
    private static ExecutorService instance = new ExecutorService();
    private Map<Database, Executor> executors = new ConcurrentHashMap<Database, Executor>();

    private ExecutorService() {
    }

    public static ExecutorService getInstance() {
        return instance;
    }

    public Executor getExecutor(Database database) {
        return this.executors.computeIfAbsent(database, db2 -> {
            try {
                Executor executor = Scope.getCurrentScope().getServiceLocator().findInstances(Executor.class).get(0);
                executor.setDatabase((Database)db2);
                return executor;
            }
            catch (Exception e2) {
                throw new UnexpectedLiquibaseException(e2);
            }
        });
    }

    public void setExecutor(Database database, Executor executor) {
        this.executors.put(database, executor);
    }

    public void clearExecutor(Database database) {
        this.executors.remove(database);
    }

    public void reset() {
        this.executors.clear();
    }
}

