/*
 * Decompiled with CFR 0.152.
 */
package liquibase.servicelocator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import liquibase.Scope;
import liquibase.exception.ServiceNotFoundException;
import liquibase.logging.Logger;
import liquibase.servicelocator.ServiceLocator;

public class StandardServiceLocator
implements ServiceLocator {
    @Override
    public <T> List<T> findInstances(Class<T> interfaceType) throws ServiceNotFoundException {
        ArrayList<T> allInstances = new ArrayList<T>();
        Logger log = Scope.getCurrentScope().getLog(this.getClass());
        Iterator<T> services = ServiceLoader.load(interfaceType, Scope.getCurrentScope().getClassLoader(true)).iterator();
        while (services.hasNext()) {
            try {
                T service = services.next();
                log.fine("Loaded " + interfaceType.getName() + " instance " + service.getClass().getName());
                allInstances.add(service);
            }
            catch (Throwable e2) {
                log.info("Cannot load service: " + e2.getMessage());
            }
        }
        return Collections.unmodifiableList(allInstances);
    }

    @Override
    public <T> List<Class<? extends T>> findClasses(Class<T> interfaceType) throws ServiceNotFoundException {
        ArrayList allInstances = new ArrayList();
        for (T t2 : this.findInstances(interfaceType)) {
            allInstances.add(t2.getClass());
        }
        return Collections.unmodifiableList(allInstances);
    }
}

