/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import liquibase.configuration.GlobalConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.util.StreamUtil;

public class FileUtil {
    private FileUtil() {
        throw new IllegalStateException("This utility class must not be instantiated. Sorry.");
    }

    private static void cleanDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        if (!directory.isDirectory()) {
            return;
        }
        IOException exception = null;
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                try {
                    FileUtil.cleanDirectory(file);
                    if (!file.delete()) {
                        throw new IOException("Cannot delete " + file.getAbsolutePath());
                    }
                }
                catch (IOException ioe) {
                    exception = ioe;
                }
            }
        }
        if (null != exception) {
            throw exception;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getContents(File file) throws IOException {
        if (!file.exists()) {
            return null;
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            String string = StreamUtil.readStreamAsString(fileInputStream);
            return string;
        }
        catch (FileNotFoundException e2) {
            return null;
        }
    }

    public static void write(String contents, File file) throws IOException {
        file.getParentFile().mkdirs();
        try (FileOutputStream output = new FileOutputStream(file);){
            StreamUtil.copy(new ByteArrayInputStream(contents.getBytes(LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class).getOutputEncoding())), output);
        }
    }
}

