/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.changelog.filter.DeploymentIdFilter;
import com.datical.liquibase.ext.command.RollbackOneUpdateCommand$1;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.changelog.ChangeLogHistoryService;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.AlreadyRanChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ContextChangeSetFilter;
import liquibase.changelog.filter.DbmsChangeSetFilter;
import liquibase.changelog.filter.IgnoreChangeSetFilter;
import liquibase.changelog.filter.LabelChangeSetFilter;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.changelog.visitor.RollbackVisitor;
import liquibase.command.AbstractSelfConfiguratingCommand;
import liquibase.command.CommandResult;
import liquibase.command.CommandValidationErrors;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.exception.LockException;
import liquibase.exception.RollbackFailedException;
import liquibase.exception.RollbackImpossibleException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;
import liquibase.logging.Logger;

public class RollbackOneUpdateCommand
extends AbstractSelfConfiguratingCommand {
    private static ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    protected static final String MSG_COULD_NOT_RELEASE_LOCK = coreBundle.getString("could.not.release.lock");
    private Database database;
    private String deploymentId;
    private String changeSetId;
    private String changeSetAuthor;
    private String changeSetPath;
    private Writer outputWriter;
    private Liquibase liquibase;
    private Boolean force;
    private Contexts contexts;
    private LabelExpression labelExpression;
    private String rollbackScript;
    private ChangeLogParameters changeLogParameters;
    private ChangeExecListener changeExecListener;
    private DatabaseChangeLog changeLog;

    @Override
    public String getName() {
        return "rollbackOneUpdate";
    }

    @Override
    public CommandValidationErrors validate() {
        return new CommandValidationErrors(this);
    }

    public void configure(Map object) {
        if (object.containsKey("help")) {
            if (object.containsKey("outputWriter")) {
                System.out.println("liquibase <global parameters> rollbackOneUpdateSQL [--deploymentId=<id>]\n\nrollbackOneUpdateSQL         Displays the SQL which will be executed when the corresponding rollbackOneUpdate command is executed, and does not\n                             perform the actual rollback.  (Liquibase Pro key required)\n\n  REQUIRED GLOBAL PARAMETERS\n    --url                    is the JDBC database connection URL\n    --username               is the database username\n    --password               is the database password\n    --changeLogFile          is the root changelog file\n    --liquibaseProLicenseKey is the Liquibase Pro license key to use\n  COMMAND PARAMETERS\n    [--deploymentId]         is the deployment ID for the update to be rolled back.\n                             If you do not specify the deployment ID, the ID for the last update will be used.");
            } else {
                System.out.println("liquibase <global parameters> rollbackOneUpdate [--deploymentId=id] --force\n\nrollbackOneUpdate            Rolls back all the changesets from one update, identified by \"deploymentId\",\n                             if all the changesets can be rolled back. If not, a WARNING message will provide\n                             details.  (Liquibase Pro key required)                             Note:  A list of deployment IDs may be viewed by using the \"history\" coammand.\n  REQUIRED GLOBAL PARAMETERS\n    --url                    is the JDBC database connection URL\n    --username               is the database username\n    --password               is the database password\n    --changeLogFile          is the root changelog file\n    --liquibaseProLicenseKey is the Liquibase Pro license key to use\n  COMMAND PARAMETERS\n    --force                  is required to make sure you intended to run this operation\n    [--deploymentId]         is the deployment ID for the update to be rolled back.\n                             If you do not specify the deployment ID, the ID for the last update will be used.");
            }
            System.exit(0);
        }
        this.deploymentId = (String)object.get("deploymentId");
        this.database = (Database)object.get("database");
        this.changeLog = (DatabaseChangeLog)object.get("changeLog");
        this.changeLogParameters = (ChangeLogParameters)object.get("changeLogParameters");
        this.force = (Boolean)object.get("force");
        if (this.force == null || !this.force.booleanValue()) {
            object = "\nWARNING: Targeted rollback of this update may result in unexpected outcomes.  To review the rollback\nSQL before executing it, please run 'rollbackOneUpdateSQL'. This message can be suppressed by adding the --force flag.";
            throw new LiquibaseException(String.format((String)object, new Object[0]));
        }
        this.liquibase = (Liquibase)object.get("liquibase");
        this.outputWriter = (Writer)object.get("outputWriter");
    }

    protected RollbackVisitor createRollbackVisitor() {
        return new RollbackVisitor(this.database, this.changeExecListener);
    }

    protected void removeRunStatus(ChangeLogIterator changeLogIterator, Contexts contexts, LabelExpression labelExpression) {
        changeLogIterator.run(new RollbackOneUpdateCommand$1(this), new RuntimeEnvironment(this.database, contexts, labelExpression));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected CommandResult run() {
        Object object;
        Object object22;
        void var4_7;
        Logger logger = Scope.getCurrentScope().getLog(this.getClass());
        Object object4 = "rollbackOneUpdate";
        Executor executor = null;
        if (this.outputWriter != null) {
            object4 = "rollbackOneUpdateSQL";
            executor = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", this.database);
            LoggingExecutor object32 = new LoggingExecutor(executor, this.outputWriter, this.database);
            Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("jdbc", this.database, object32);
            Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("logging", this.database, object32);
        } else {
            LoggingExecutor lockException = new LoggingExecutor(null, null, this.database);
        }
        Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("logging", this.database, (Executor)var4_7);
        List<RanChangeSet> list = this.database.getRanChangeSetList();
        if (this.deploymentId == null) {
            this.deploymentId = this.getLastDeploymentId(list);
            if (this.deploymentId == null) {
                throw new LiquibaseException(String.format(coreBundle.getString("no.deployment.ids.found"), new Object[0]));
            }
            Scope.getCurrentScope().getUI().sendMessage("Defaulting to last deployment ID '" + this.deploymentId + "'");
        } else {
            boolean bl2 = false;
            for (Object object22 : list) {
                if (!this.deploymentId.equals(((RanChangeSet)object22).getDeploymentId())) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                object = String.format(coreBundle.getString("no.change.sets.found.for.deployment.id"), this.deploymentId);
                throw new LiquibaseException("\n".concat(String.valueOf(object)));
            }
        }
        this.liquibase.outputHeader("Rollback deployment ID '" + this.deploymentId + "'");
        LockService lockService = LockServiceFactory.getInstance().getLockService(this.database);
        lockService.waitForLock();
        try {
            this.checkLiquibaseTables(false, this.changeLog, this.contexts, this.labelExpression);
            this.changeLog.validate(this.database, this.contexts, this.labelExpression);
            object = new DeploymentIdFilter(this.deploymentId, this.database, list, this.changeLog, (String)object4);
            if (!((DeploymentIdFilter)object).getNoInverseChangeSets().isEmpty()) {
                object22 = "\n\nThere are change sets associated with the deployment ID '" + this.deploymentId + "' which cannot be rolled back.\nNo rollback was performed.\n";
                object22 = (String)object22 + "\nChange Sets which cannot be rolled back:\n";
                for (Map.Entry entry : ((DeploymentIdFilter)object).getNoInverseChangeSets().entrySet()) {
                    object22 = (String)object22 + (String)entry.getKey();
                    object22 = (String)object22 + "\n";
                }
                throw new LiquibaseException("\n".concat(String.valueOf(object22)));
            }
            if (((DeploymentIdFilter)object).isEmpty()) {
                object22 = "\n\nThere are no change sets associated with the deployment ID '" + this.deploymentId + "'.\nPlease check your parameters.  No rollback was performed.\n";
                throw new LiquibaseException("\n".concat(String.valueOf(object22)));
            }
            this.createChangeLogIterator(list, (ChangeSetFilter)object).run(this.createRollbackVisitor(), new RuntimeEnvironment(this.database, this.contexts, this.labelExpression));
        }
        catch (RollbackFailedException rollbackFailedException) {
            object = rollbackFailedException;
            object22 = rollbackFailedException.getCause();
            if (object22 != null && object22 instanceof RollbackImpossibleException) {
                object4 = "\nError executing rollback:\nThe rollback for deployment ID '" + this.deploymentId + "' has at least one change set without a rollback defined\nPlease add a rollback change in the appropriate changeset.\n";
                logger.severe((String)object4, (Throwable)object);
                if (this.changeExecListener != null) {
                    this.changeExecListener.runFailed(null, this.changeLog, this.database, (Exception)object);
                }
                throw new LiquibaseException((String)object4, (Throwable)object);
            }
            logger.severe("\nError executing rollback for the deployment ID '" + this.deploymentId + "'.");
            if (this.changeExecListener != null) {
                this.changeExecListener.runFailed(null, this.changeLog, this.database, (Exception)object);
            }
            throw new LiquibaseException("\nError executing rollback for the deployment ID '" + this.deploymentId + "':\n" + ((Throwable)object).getMessage(), (Throwable)object);
        }
        finally {
            try {
                lockService.releaseLock();
            }
            catch (LockException lockException) {
                logger.severe(MSG_COULD_NOT_RELEASE_LOCK, lockException);
            }
            if (executor != null) {
                Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("jdbc", this.database, executor);
            }
        }
        this.resetServices();
        return new CommandResult("rollbackOneChangeSet executed for " + this.database.getConnection().getConnectionUserName() + "@" + this.database.getConnection().getURL());
    }

    private String getLastDeploymentId(List<RanChangeSet> object) {
        if (object == null || object.size() == 0) {
            return null;
        }
        List<RanChangeSet> list = object;
        object = list.get(list.size() - 1).getDeploymentId();
        if (object == null) {
            return null;
        }
        return object;
    }

    protected ChangeLogIterator createChangeLogIterator(List<RanChangeSet> list, ChangeSetFilter changeSetFilter) {
        return new ChangeLogIterator(list, this.changeLog, changeSetFilter, new AlreadyRanChangeSetFilter(list), new ContextChangeSetFilter(this.contexts), new LabelChangeSetFilter(this.labelExpression), new IgnoreChangeSetFilter(), new DbmsChangeSetFilter(this.database));
    }

    protected void checkLiquibaseTables(boolean bl2, DatabaseChangeLog databaseChangeLog, Contexts contexts, LabelExpression labelExpression) {
        ChangeLogHistoryService changeLogHistoryService = ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(this.database);
        changeLogHistoryService.init();
        if (bl2) {
            changeLogHistoryService.upgradeChecksums(databaseChangeLog, contexts, labelExpression);
        }
        LockServiceFactory.getInstance().getLockService(this.database).init();
    }

    protected void resetServices() {
        LockServiceFactory.getInstance().resetAll();
        ChangeLogHistoryServiceFactory.getInstance().resetAll();
        Scope.getCurrentScope().getSingleton(ExecutorService.class).reset();
    }
}

