/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import liquibase.ContextExpression;
import liquibase.Labels;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilterResult;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.changelog.visitor.SkippedChangeSetVisitor;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.logging.Logger;
import liquibase.util.StringUtil;

public class ChangeLogIterator {
    private DatabaseChangeLog databaseChangeLog;
    private List<ChangeSetFilter> changeSetFilters;
    private static ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    protected static final String MSG_COULD_NOT_FIND_EXECUTOR = coreBundle.getString("no.executor.found");
    private Set<String> seenChangeSets = new HashSet<String>();

    public ChangeLogIterator(DatabaseChangeLog databaseChangeLog, ChangeSetFilter ... changeSetFilters) {
        this.databaseChangeLog = databaseChangeLog;
        this.changeSetFilters = Arrays.asList(changeSetFilters);
    }

    public ChangeLogIterator(List<RanChangeSet> changeSetList, DatabaseChangeLog changeLog, ChangeSetFilter ... changeSetFilters) {
        final ArrayList<ChangeSet> changeSets = new ArrayList<ChangeSet>();
        for (RanChangeSet ranChangeSet : changeSetList) {
            ChangeSet changeSet = changeLog.getChangeSet(ranChangeSet);
            if (changeSet == null) continue;
            changeSet.setFilePath(DatabaseChangeLog.normalizePath(ranChangeSet.getChangeLog()));
            changeSets.add(changeSet);
        }
        this.databaseChangeLog = new DatabaseChangeLog(){

            @Override
            public List<ChangeSet> getChangeSets() {
                return changeSets;
            }

            @Override
            public String toString() {
                return "";
            }
        };
        this.changeSetFilters = Arrays.asList(changeSetFilters);
    }

    public void run(final ChangeSetVisitor visitor, final RuntimeEnvironment env) throws LiquibaseException {
        Logger log = Scope.getCurrentScope().getLog(this.getClass());
        this.databaseChangeLog.setRuntimeEnvironment(env);
        try {
            Scope.child(Scope.Attr.databaseChangeLog, (Object)this.databaseChangeLog, new Scope.ScopedRunner(){

                @Override
                public void run() throws Exception {
                    ArrayList<ChangeSet> changeSetList = new ArrayList<ChangeSet>(ChangeLogIterator.this.databaseChangeLog.getChangeSets());
                    if (visitor.getDirection().equals((Object)ChangeSetVisitor.Direction.REVERSE)) {
                        Collections.reverse(changeSetList);
                    }
                    for (final ChangeSet changeSet : changeSetList) {
                        boolean shouldVisit = true;
                        final HashSet<ChangeSetFilterResult> reasonsAccepted = new HashSet<ChangeSetFilterResult>();
                        final HashSet<ChangeSetFilterResult> reasonsDenied = new HashSet<ChangeSetFilterResult>();
                        if (ChangeLogIterator.this.changeSetFilters != null) {
                            for (ChangeSetFilter filter : ChangeLogIterator.this.changeSetFilters) {
                                ChangeSetFilterResult acceptsResult = filter.accepts(changeSet);
                                if (acceptsResult.isAccepted()) {
                                    reasonsAccepted.add(acceptsResult);
                                    continue;
                                }
                                shouldVisit = false;
                                reasonsDenied.add(acceptsResult);
                                break;
                            }
                        }
                        final boolean finalShouldVisit = shouldVisit;
                        Scope.child(Scope.Attr.changeSet, (Object)changeSet, new Scope.ScopedRunner(){

                            @Override
                            public void run() throws Exception {
                                if (finalShouldVisit && !ChangeLogIterator.this.alreadySaw(changeSet)) {
                                    ChangeLogIterator.this.validateChangeSetExecutor(changeSet, env);
                                    visitor.visit(changeSet, ChangeLogIterator.this.databaseChangeLog, env.getTargetDatabase(), reasonsAccepted);
                                    ChangeLogIterator.this.markSeen(changeSet);
                                } else if (visitor instanceof SkippedChangeSetVisitor) {
                                    ((SkippedChangeSetVisitor)((Object)visitor)).skipped(changeSet, ChangeLogIterator.this.databaseChangeLog, env.getTargetDatabase(), reasonsDenied);
                                }
                            }
                        });
                    }
                }
            });
        }
        catch (Exception e2) {
            throw new LiquibaseException(e2);
        }
        finally {
            this.databaseChangeLog.setRuntimeEnvironment(null);
        }
    }

    private void validateChangeSetExecutor(ChangeSet changeSet, RuntimeEnvironment env) throws LiquibaseException {
        Executor executor;
        if (changeSet.getRunWith() == null) {
            return;
        }
        String executorName = changeSet.getRunWith();
        try {
            executor = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor(executorName, env.getTargetDatabase());
        }
        catch (UnexpectedLiquibaseException ule) {
            String message = String.format(MSG_COULD_NOT_FIND_EXECUTOR, executorName, changeSet.toString());
            Scope.getCurrentScope().getLog(this.getClass()).severe(message);
            throw new LiquibaseException(message);
        }
        executor.modifyChangeSet(changeSet);
        ValidationErrors errors = executor.validate(changeSet);
        if (errors.hasErrors()) {
            String message = errors.toString();
            Scope.getCurrentScope().getLog(this.getClass()).severe(message);
            throw new LiquibaseException(message);
        }
    }

    protected void markSeen(ChangeSet changeSet) {
        if (changeSet.key == null) {
            changeSet.key = this.createKey(changeSet);
        }
        this.seenChangeSets.add(changeSet.key);
    }

    protected String createKey(ChangeSet changeSet) {
        Labels labels = changeSet.getLabels();
        ContextExpression contexts = changeSet.getContexts();
        return changeSet.toString(true) + ":" + (labels == null ? null : labels.toString()) + ":" + (contexts == null ? null : contexts.toString()) + ":" + StringUtil.join(changeSet.getDbmsSet(), ",");
    }

    protected boolean alreadySaw(ChangeSet changeSet) {
        if (changeSet.key == null) {
            changeSet.key = this.createKey(changeSet);
        }
        return this.seenChangeSets.contains(changeSet.key);
    }

    public List<ChangeSetFilter> getChangeSetFilters() {
        return Collections.unmodifiableList(this.changeSetFilters);
    }
}

