/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog;

import java.io.IOException;
import java.io.StringReader;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.UnknownChangeLogParameterException;
import liquibase.parser.ChangeLogParserConfiguration;

class ExpressionExpander {
    private final boolean enableEscaping = ChangeLogParserConfiguration.SUPPORT_PROPERTY_ESCAPING.getCurrentValue();
    private final ChangeLogParameters parameters;

    public ExpressionExpander(ChangeLogParameters parameters) {
        this.parameters = parameters;
    }

    public String expandExpressions(String text, DatabaseChangeLog changeLog) throws UnknownChangeLogParameterException {
        if (text == null) {
            return null;
        }
        return this.expandExpressions(new StringReader(text), changeLog, false);
    }

    private String expandExpressions(StringReader reader, DatabaseChangeLog changeLog, boolean inExpression) throws UnknownChangeLogParameterException {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int nextChar = reader.read();
            while (nextChar != -1) {
                if (nextChar == 36) {
                    reader.mark(1);
                    if (reader.read() == 123) {
                        reader.mark(1);
                        if (this.enableEscaping && reader.read() == 58) {
                            stringBuilder.append("${");
                            stringBuilder.append(this.expandExpressions(reader, changeLog, true).trim());
                            stringBuilder.append("}");
                        } else {
                            inExpression = true;
                            reader.reset();
                            String paramExpression = this.expandExpressions(reader, changeLog, true);
                            Object paramValue = this.parameters.getValue(paramExpression.trim(), changeLog);
                            if (paramValue == null) {
                                ChangeLogParserConfiguration.MissingPropertyMode missingPropertyMode = ChangeLogParserConfiguration.MISSING_PROPERTY_MODE.getCurrentValue();
                                switch (missingPropertyMode) {
                                    case EMPTY: {
                                        paramValue = "";
                                        break;
                                    }
                                    case ERROR: {
                                        throw new UnknownChangeLogParameterException("Could not resolve expression `${" + paramExpression + "}` in file " + changeLog.getPhysicalFilePath());
                                    }
                                    case PRESERVE: {
                                        paramValue = "${" + paramExpression + "}";
                                        break;
                                    }
                                    default: {
                                        throw new UnexpectedLiquibaseException("Unknown MissingPropertyMode: " + (Object)((Object)missingPropertyMode));
                                    }
                                }
                            } else if (paramValue instanceof String) {
                                paramValue = this.expandExpressions((String)paramValue, changeLog);
                            }
                            stringBuilder.append(paramValue);
                        }
                    } else {
                        reader.reset();
                        stringBuilder.append("$");
                    }
                } else {
                    if (nextChar == 125 && inExpression) {
                        return stringBuilder.toString();
                    }
                    stringBuilder.append((char)nextChar);
                }
                nextChar = reader.read();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuilder.toString();
    }
}

